# Output Format

> review-task Skill의 출력 형식 상세

## 기본 출력 구조

```markdown
[SEMO] Skill: review-task 호출 - {repo}#{issue_number}

=== 태스크 리뷰: {repo}#{issue_number} ===

## 이슈 정보

| 항목 | 값 |
|------|-----|
| **제목** | {title} |
| **URL** | {issue_url} |
| **브랜치** | `{branch_name}` |
| **상태** | {draft_status} |

## Phase 1: 메타데이터 검증

### Draft 상태
{draft_result}

### 브랜치명 규칙
{branch_result}

## Phase 2: 테스트 구조 검증

### 테스트 섹션 분리
{test_structure_result}

### 테스트 코드 존재
{test_code_result}

## Phase 3: 아키텍처 검증

### DDD 레이어 준수
{ddd_result}

### 팀 컨벤션
{convention_result}

## Phase 4: 기능 구현 확인

### Acceptance Criteria

| # | 항목 | 상태 | 관련 코드 |
|---|------|------|----------|
| 1 | {ac_1} | ✅ | `{file}:{line}` |
| 2 | {ac_2} | ❌ | - |

**구현율**: {completed}/{total} ({percentage}%)

## Phase 5: 품질 게이트

| 체크 | 상태 | 상세 |
|------|------|------|
| ESLint | ✅ | 0 errors |
| TypeScript | ✅ | 0 errors |
| Tests | ✅ | 15/15 passing |
| Coverage | 🟡 | 75% (목표: 80%) |

## 리뷰 요약

| Phase | 상태 | 요약 |
|-------|------|------|
| 메타데이터 | ✅ | Draft 제거됨, 브랜치명 준수 |
| 테스트 구조 | 🟡 | QA 섹션 분리 권장 |
| 아키텍처 | ✅ | DDD 4레이어 준수 |
| 기능 구현 | ✅ | AC 5/5 충족 |
| 품질 게이트 | ✅ | 모든 체크 통과 |

## 최종 결과

{verdict}

### {verdict_icon} {verdict_title}

{verdict_detail}

---

{next_action}
```

## 상태 아이콘

| 아이콘 | 의미 | 사용 상황 |
|--------|------|----------|
| ✅ | Pass | 조건 충족 |
| 🔴 | Critical | PR 차단 사유 |
| 🟡 | Warning | 수정 권장 |
| 🟢 | Info | 참고 사항 |

## 최종 결과 유형

### PR 가능 (모두 통과)

```markdown
## 최종 결과

### ✅ PR 가능

모든 리뷰 항목을 통과했습니다.

**다음 단계**:
> PR을 생성하려면: "PR 만들어줘"
```

### PR 가능 (경고 있음)

```markdown
## 최종 결과

### ✅ PR 가능 (경고 {n}건)

Critical 이슈 없이 리뷰를 통과했습니다.
경고 사항은 수정을 권장하지만 필수는 아닙니다.

**경고 목록**:
- 🟡 테스트 섹션 분리 권장
- 🟡 Coverage 75% (목표: 80%)

**다음 단계**:
> PR을 생성하려면: "PR 만들어줘"
> 경고 수정 후 재검토: "다시 리뷰해줘"
```

### PR 차단

```markdown
## 최종 결과

### 🔴 PR 차단 - 수정 필요

다음 Critical 이슈를 해결해야 합니다:

**차단 사유**:
- 🔴 Draft 상태 미전환 - [Draft] 접두사 제거 필요
- 🔴 AC 미충족 - "Twitter Card 지원" 미구현
- 🔴 테스트 실패 - 3개 테스트 실패

**다음 단계**:
> Draft 전환: "이슈 Draft 해제해줘"
> 미구현 기능: "Twitter Card 구현해줘"
> 테스트 수정: "실패한 테스트 확인해줘"
```

## 축약 출력 (--brief)

간략한 결과만 표시:

```markdown
[SEMO] Skill: review-task 호출 - cm-land#565

=== 태스크 리뷰 요약 ===

| Phase | 상태 |
|-------|------|
| 메타데이터 | ✅ |
| 테스트 구조 | 🟡 |
| 아키텍처 | ✅ |
| 기능 구현 | ✅ (5/5) |
| 품질 게이트 | ✅ |

**결과**: ✅ PR 가능 (경고 1건)
```

## JSON 출력 (--json)

프로그래매틱 사용을 위한 JSON 형식:

```json
{
  "issue": {
    "number": 565,
    "repo": "cm-land",
    "title": "메타태그 기능구현",
    "url": "https://github.com/semicolon-devteam/cm-land/issues/565"
  },
  "branch": {
    "name": "565-metatag-implements",
    "valid": true
  },
  "phases": {
    "metadata": { "status": "pass", "draft": false, "branchValid": true },
    "testStructure": { "status": "warning", "separated": false },
    "architecture": { "status": "pass", "dddCompliant": true },
    "implementation": { "status": "pass", "completed": 5, "total": 5 },
    "qualityGates": { "status": "pass", "lint": true, "tsc": true, "tests": true }
  },
  "verdict": {
    "canPR": true,
    "criticalCount": 0,
    "warningCount": 1
  }
}
```
