# Decision Log Template

> 의사결정 로그 Discussion 생성 시 사용하는 템플릿

## 제목 형식

```text
[{YYYY-MM-DD}] {의사결정 제목}
```

**예시**:
- `[2026-01-02] 서비스 아키텍처 변경`
- `[2026-01-02] 신규 프로젝트 진행 승인`

## Decision ID 생성

```text
DEC-{YYYYMMDD}-{순번}
```

**예시**: `DEC-20260102-001`

## 본문 템플릿

```markdown
# {의사결정 제목}

> **결정일**: {YYYY-MM-DD}
> **결정자**: {결정 참여자 목록}
> **ID**: DEC-{YYYYMMDD}-{NNN}
> **상태**: ✅ 확정 / ⏳ 검토중 / ❌ 철회

---

## 📋 배경

{의사결정이 필요했던 배경과 맥락 설명}

### 문제 상황

- {문제점 1}
- {문제점 2}

### 결정 필요성

{왜 이 결정이 필요한지 설명}

---

## 🎯 결정 사항

{최종 결정 내용을 명확하게 기술}

### 세부 내용

1. {세부 결정 1}
2. {세부 결정 2}
3. {세부 결정 3}

---

## 📊 검토된 대안

| # | 대안 | 장점 | 단점 | 선택 |
|---|------|------|------|------|
| 1 | {대안1 설명} | {장점} | {단점} | ❌ |
| 2 | {대안2 설명} | {장점} | {단점} | ❌ |
| 3 | {선택된 대안} | {장점} | {단점} | ✅ |

### 선택 이유

{왜 이 대안을 선택했는지 설명}

---

## 📅 적용 계획

| 단계 | 내용 | 담당 | 예정일 |
|------|------|------|--------|
| 1 | {적용 단계} | @{담당자} | {날짜} |

---

## ⚠️ 리스크 및 고려사항

- **리스크 1**: {리스크 설명}
  - 대응: {대응 방안}
- **리스크 2**: {리스크 설명}
  - 대응: {대응 방안}

---

## 📎 관련 문서

- 관련 회의록: [링크](discussion_url)
- 관련 이슈: #{issue_number}
- 참고 자료: [링크]

---

## 📝 변경 이력

| 날짜 | 변경 내용 | 변경자 |
|------|----------|--------|
| {YYYY-MM-DD} | 최초 결정 | @{결정자} |
```

## 필수 섹션

| 섹션 | 필수 | 설명 |
|------|------|------|
| 메타 정보 (결정일, ID) | ✅ | 항상 포함 |
| 배경 | ✅ | 결정 맥락 |
| 결정 사항 | ✅ | 핵심 내용 |
| 검토된 대안 | ⚪ | 비교 분석 시 |
| 적용 계획 | ⚪ | 실행 필요 시 |

## 상태 표기

| 상태 | 의미 |
|------|------|
| ✅ 확정 | 최종 결정됨 |
| ⏳ 검토중 | 추가 검토 필요 |
| ❌ 철회 | 결정 취소됨 |
