---
name: write-portfolio
description: |
  프로젝트 포트폴리오 문서 자동 생성. Use when (1) 포트폴리오 작성 요청,
  (2) 프로젝트 문서화, (3) 레퍼런스 링크 기반 프로젝트 분석,
  (4) 기술스택/기능 정리, (5) 서비스 스크린샷 캡처.
tools: [WebFetch, Read, Write, Bash, Glob, Grep]
mcp_tools: [playwright, github]
---

> **시스템 메시지**: `[SEMO] Skill: write-portfolio 실행 - {project-name}`

# write-portfolio Skill

프로젝트 정보를 수집하고 포트폴리오 문서를 자동 생성합니다.

## Output Structure

```
docs/portfolio/{project-name}/
├── images/                    # 스크린샷, 다이어그램
│   ├── screenshot-main.png
│   ├── screenshot-feature-1.png
│   └── architecture.png
├── documents/
│   ├── PROPOSAL.md           # 프로젝트 제안서
│   ├── TECH_STACK.md         # 기술스택 상세
│   └── FEATURES.md           # 주요 기능 설명
└── README.md                 # 포트폴리오 메인
```

## Workflow

### Step 1: 프로젝트 정보 수집

사용자에게 다음 정보를 요청:

```markdown
## 포트폴리오 생성 정보

| 항목 | 설명 | 필수 |
|------|------|------|
| **프로젝트명** | 영문 kebab-case (예: my-project) | ✅ |
| **서비스 URL** | 배포된 서비스 주소 | 선택 |
| **GitHub URL** | 소스코드 저장소 | 선택 |
| **Notion/문서 URL** | 기획 문서, 명세서 | 선택 |
| **프로젝트 설명** | 한 줄 요약 | ✅ |
| **역할** | 본인이 담당한 역할 | ✅ |
| **기간** | 개발 기간 | ✅ |
```

### Step 2: 레퍼런스 분석

#### 2.1 서비스 URL 분석

```markdown
[WebFetch 사용]
- 메인 페이지 콘텐츠 추출
- 주요 기능 페이지 파악
- UI/UX 특징 기록
```

#### 2.2 GitHub 저장소 분석

```markdown
[GitHub MCP 사용]
- README.md 분석
- package.json / build.gradle 등에서 기술스택 추출
- 디렉토리 구조 파악
- 주요 기능 코드 분석
```

#### 2.3 문서 URL 분석

```markdown
[WebFetch 사용]
- Notion: 페이지 콘텐츠 추출
- Figma: 디자인 정보 (접근 가능 시)
- 기타 문서: 요구사항, 기획서 내용 파악
```

### Step 3: 기술스택 분석

#### 자동 감지 패턴

| 파일 | 추출 정보 |
|------|----------|
| `package.json` | dependencies, devDependencies |
| `build.gradle.kts` | Kotlin, Spring Boot 버전 |
| `go.mod` | Go 모듈, 의존성 |
| `requirements.txt` | Python 패키지 |
| `Dockerfile` | 베이스 이미지, 런타임 |
| `docker-compose.yml` | 인프라 구성 |

#### 기술스택 분류

```markdown
## Tech Stack

### Frontend
- Framework: Next.js 14
- Language: TypeScript
- Styling: Tailwind CSS
- State: Zustand

### Backend
- Framework: Spring Boot 3.2
- Language: Kotlin
- Database: PostgreSQL
- Cache: Redis

### Infrastructure
- Cloud: AWS (EC2, RDS, S3)
- CI/CD: GitHub Actions
- Container: Docker
```

### Step 4: 스크린샷 캡처

#### Playwright MCP 활용

```markdown
[서비스 URL이 있는 경우]

1. 메인 페이지 캡처
   - mcp__playwright__playwright_navigate → URL 접속
   - mcp__playwright__playwright_screenshot → 전체 페이지 캡처

2. 주요 기능 페이지 캡처
   - 로그인/회원가입
   - 대시보드
   - 핵심 기능 화면

3. 반응형 캡처 (선택)
   - mcp__playwright__playwright_resize → 모바일 뷰포트
   - 모바일 레이아웃 캡처
```

#### 캡처 저장

```bash
# 저장 경로
docs/portfolio/{project-name}/images/

# 파일명 컨벤션
screenshot-{page-name}.png
screenshot-mobile-{page-name}.png
```

### Step 5: 문서 생성

#### README.md 템플릿

```markdown
# {프로젝트명}

> {한 줄 설명}

![메인 스크린샷](./images/screenshot-main.png)

## Overview

{프로젝트 개요 2-3문장}

## Key Features

- **{기능1}**: {설명}
- **{기능2}**: {설명}
- **{기능3}**: {설명}

## Tech Stack

| Category | Technologies |
|----------|-------------|
| Frontend | {기술 목록} |
| Backend | {기술 목록} |
| Database | {기술 목록} |
| Infra | {기술 목록} |

## My Role

- {역할 및 담당 업무}
- {주요 기여 사항}

## Duration

{시작일} ~ {종료일} ({기간})

## Links

- [Live Demo]({서비스 URL})
- [GitHub]({저장소 URL})

## Screenshots

### Main Page
![Main](./images/screenshot-main.png)

### Feature 1
![Feature1](./images/screenshot-feature-1.png)

---

*Generated by SEMO write-portfolio skill*
```

#### PROPOSAL.md 템플릿

```markdown
# {프로젝트명} 제안서

## 1. 프로젝트 개요

### 배경
{프로젝트를 시작하게 된 배경}

### 목표
{달성하고자 하는 목표}

## 2. 주요 기능

### 2.1 {기능명}
{기능 상세 설명}

## 3. 기술적 도전

### 3.1 {도전 과제}
- **문제**: {직면한 문제}
- **해결**: {해결 방법}

## 4. 결과 및 성과

{프로젝트 결과 및 성과 지표}
```

## SEMO Message

```markdown
[SEMO] Skill: write-portfolio 실행 - {project-name}

## 포트폴리오 생성 시작

**프로젝트**: {project-name}
**대상 경로**: `docs/portfolio/{project-name}/`

### 수집된 정보
- 서비스 URL: {url or "없음"}
- GitHub: {url or "없음"}
- 문서: {url or "없음"}

### 진행 상황
- [ ] 레퍼런스 분석
- [ ] 기술스택 추출
- [ ] 스크린샷 캡처
- [ ] 문서 생성
```

## Output Format

### 완료 메시지

```markdown
[SEMO] Skill: write-portfolio → 완료

## 포트폴리오 생성 완료

**프로젝트**: {project-name}
**경로**: `docs/portfolio/{project-name}/`

### 생성된 파일

| 파일 | 설명 |
|------|------|
| README.md | 메인 포트폴리오 |
| documents/PROPOSAL.md | 프로젝트 제안서 |
| documents/TECH_STACK.md | 기술스택 상세 |
| images/*.png | 스크린샷 {n}장 |

### 다음 단계

1. 내용 검토 및 수정
2. 추가 스크린샷 필요 시 요청
3. GitHub에 커밋
```

## Error Handling

| 상황 | 대응 |
|------|------|
| 서비스 URL 접근 불가 | 스크린샷 건너뛰기, 사용자에게 이미지 요청 |
| GitHub private repo | 토큰 권한 확인, 접근 가능한 정보만 사용 |
| Notion 접근 불가 | 공개 페이지만 분석, 사용자에게 내용 요청 |

## References

- [Portfolio Structure](references/portfolio-structure.md)
- [Analysis Workflow](references/analysis-workflow.md)
- [Screenshot Guide](references/screenshot-guide.md)
