# Agent Teams Skill

Скилл для Claude Code — оркестрация нескольких автономных агентов с общим списком задач и прямым обменом сообщениями.

## Проблема

Сложные задачи часто требуют параллельной работы в разных доменах (фронтенд + бэкенд, безопасность + производительность). Одиночные агенты или простые субагенты не могут координироваться — они работают изолированно без общего состояния и обмена сообщениями.

## Решение

Используй **Agent Teams** в Claude Code — создавай тиммейтов с общим списком задач, прямыми сообщениями и самокоординацией.

## Структура

```
agent-teams/
└── SKILL.md    # Основной скилл с жизненным циклом, паттернами и best practices
```

## Установка

```bash
cp -r skills/agent-teams ~/.claude/skills/
```

## Требования

- Claude Code с включёнными Agent Teams
- Включить в `~/.claude/settings.json`:
  ```json
  { "env": { "CLAUDE_CODE_EXPERIMENTAL_AGENT_TEAMS": "1" } }
  ```

## Быстрый старт

Просто опиши задачу:

```
Создай команду для ревью PR #42:
- Ревьюер безопасности для модуля авторизации
- Ревьюер производительности для запросов к БД
- Ревьюер покрытия тестами
```

Или используй инструменты напрямую:

```
1. Teammate(operation="spawnTeam", team_name="review")
2. TaskCreate(subject="Review auth security", ...)
3. Task(subagent_type="general-purpose", team_name="review", name="security-rev", ...)
4. TaskUpdate(taskId="1", owner="security-rev")
```

## Ключевые концепции

| Концепция | Описание |
|-----------|----------|
| **Team** | Группа агентов с общим списком задач |
| **Teammate** | Автономный агент со своим контекстом |
| **Task List** | Общий для всех участников команды |
| **SendMessage** | Прямые сообщения между агентами |
| **Idle state** | Нормальное состояние — тиммейт ждёт ввода, не ошибка |

## Teams vs Субагенты

| | Субагенты | Teams |
|---|-----------|-------|
| Коммуникация | Только обратно к вызывающему | Агенты общаются друг с другом |
| Координация | Вызывающий управляет | Общий список задач |
| Стоимость | Ниже | Выше |
| Лучше для | Фокусные задачи | Коллаборация |

## Типичные ошибки

| Ошибка | Исправление |
|--------|-------------|
| Два агента редактируют один файл | Явно разделяй владение файлами |
| Скудные spawn-промпты | Включай полный контекст — тиммейты не наследуют историю |
| Broadcast для рутинных обновлений | Используй прямое сообщение конкретному тиммейту |
| Слишком много тиммейтов | Оптимально 2-4, больше добавляет overhead координации |

## Применение

- Мульти-ревью кода (безопасность, производительность, тесты параллельно)
- Кросс-слойная разработка фич (фронтенд + бэкенд + тесты)
- Исследование с конкурирующими гипотезами
- Крупный рефакторинг с раздельным владением модулями

## См. также

- [Claude Code Agent Teams Documentation](https://code.claude.com/docs/en/agent-teams)
- [Building Multi-Agent Systems (Anthropic Blog)](https://www.anthropic.com/engineering/building-effective-agents)
