# Claude Code Analytics Skill

Скилл для Claude Code — генерация HTML-отчётов статистики использования.

## Проблема

Отслеживание активности Claude Code по проектам вручную — нет встроенного способа видеть промпты, коммиты и активность за период.

## Решение

- Парсинг `~/.claude/history.jsonl` для данных использования
- Сбор git remote URL и количества коммитов по проектам
- Генерация HTML-отчёта в терминальном стиле с ASCII-эстетикой
- Открытие в браузере

## Установка

```bash
cp -r skills/cc-analytics ~/.claude/skills/
```

## Краткий справочник

### Триггеры

| Фраза | Язык |
|-------|------|
| "аналитика", "статистика claude" | RU |
| "cc stats", "weekly report" | EN |
| "что делал за неделю" | RU |

### Метрики

| Метрика | Источник |
|---------|----------|
| Проекты | Уникальные пути в history.jsonl |
| Промпты | Всего записей по проекту |
| Коммиты | `git rev-list --count --since` |
| Дни | Уникальные даты с активностью |

## Содержимое отчёта

- ASCII art заголовок с диапазоном дат
- Сводка (проекты, промпты, коммиты, дни)
- Таблица проектов со ссылками на remote
- ASCII bar chart активности

## Ключевые фичи

- Терминальная эстетика (моноширинный шрифт, тёмная тема, ASCII art)
- Git-интеграция для подсчёта коммитов и remote
- Настраиваемый период (по умолчанию: 7 дней)
- Один HTML-файл на выходе

## См. также

- [Документация Claude Code](https://docs.anthropic.com/claude-code)
