# OpenCode Configuration Skill

Скилл для Claude Code — настройка OpenCode CLI: добавление провайдеров, смена моделей, установка кастомных baseURL.

## Проблема

Конфигурация OpenCode CLI разбросана по нескольким файлам с разными приоритетами. Кастомные провайдеры (особенно с подписко-специфичными baseURL) требуют специфической настройки, в которой легко ошибиться.

## Решение

- Понятные локации конфиг-файлов и их приоритеты
- Настройка кастомных провайдеров с OpenAI-совместимыми API
- Конфигурация моделей для разных режимов
- Гайд по траблшутингу частых проблем

## Установка

```bash
cp -r skills/opencode-config ~/.claude/skills/
```

## Краткий справочник

### Локации конфигов

| Локация | Путь | Приоритет |
|---------|------|-----------|
| Проект | `./opencode.json` | Высший |
| Глобальный | `~/.config/opencode/opencode.json` | Средний |
| Auth | `~/.local/share/opencode/auth.json` | Креды |

### Базовый конфиг

```json
{
  "$schema": "https://opencode.ai/config.json",
  "model": "provider/model-name",
  "provider": {
    "my-provider": {
      "options": {
        "baseURL": "https://api.example.com/v1"
      }
    }
  }
}
```

### CLI команды

| Команда | Описание |
|---------|----------|
| `/connect` | Добавить креды провайдера |
| `/models` | Выбрать модель |
| `opencode auth list` | Список провайдеров |

## Ключевые фичи

- Объяснение приоритетов конфигов
- Настройка кастомных провайдеров
- Модели для разных режимов (build/plan)
- Чеклист траблшутинга

## См. также

- [Документация OpenCode](https://opencode.ai/docs)
