# TTS-Friendly Formatting Reference

This reference provides comprehensive guidelines for formatting text to work optimally with Text-to-Speech (TTS) engines across different languages.

## Contents
1. [Numbers and Years](#numbers-and-years)
2. [Abbreviations](#abbreviations)
3. [Dates and Currency](#dates-and-currency)
4. [Units and Measurements](#units-and-measurements)
5. [URLs and Technical Terms](#urls-and-technical-terms)

## Numbers and Years

Write all numbers in words appropriate to the target language. TTS engines handle written-out numbers more reliably than digits.

### English
- **Years**: "1989" → "nineteen eighty-nine", "2025" → "twenty twenty-five"
- **Large numbers**: "3.7 million" not "3.7M", "100 thousand" not "100K"
- **Decimals**: "three point seven" not "3.7"
- **Percentages**: "twenty percent" not "20%"
- **Ordinals**: "first", "second", "third" not "1st", "2nd", "3rd"

### German (Deutsch)
- **Years**: "1989" → "neunzehn hundert neunundachtzig", "2025" → "zwanzig hundert fünfundzwanzig"
- **Large numbers**: "3,7 Millionen" not "3,7M", "100 Tausend" not "100T"
- **Decimals**: "drei Komma sieben" not "3,7"
- **Percentages**: "zwanzig Prozent" not "20%"
- **Ordinals**: "erste", "zweite", "dritte" not "1.", "2.", "3."

### French (Français)
- **Years**: "1989" → "mille neuf cent quatre-vingt-neuf", "2025" → "deux mille vingt-cinq"
- **Large numbers**: "3,7 millions" not "3,7M"
- **Decimals**: "trois virgule sept" not "3,7"
- **Percentages**: "vingt pour cent" not "20%"
- **Ordinals**: "premier", "deuxième", "troisième" not "1er", "2e", "3e"

### Spanish (Español)
- **Years**: "1989" → "mil novecientos ochenta y nueve", "2025" → "dos mil veinticinco"
- **Large numbers**: "3,7 millones" not "3,7M"
- **Decimals**: "tres coma siete" not "3,7"
- **Percentages**: "veinte por ciento" not "20%"
- **Ordinals**: "primero", "segundo", "tercero" not "1º", "2º", "3º"

### Italian (Italiano)
- **Years**: "1989" → "millenovecentoottantanove", "2025" → "duemilaventicinque"
- **Large numbers**: "3,7 milioni" not "3,7M"
- **Decimals**: "tre virgola sette" not "3,7"
- **Percentages**: "venti per cento" not "20%"
- **Ordinals**: "primo", "secondo", "terzo" not "1º", "2º", "3º"

## Abbreviations

Spell out all abbreviations in the appropriate language. TTS engines cannot reliably determine the correct pronunciation of abbreviated forms.

### Titles
- **English**: "Doctor" not "Dr.", "Mister" not "Mr.", "Professor" not "Prof."
- **German**: "Doktor" not "Dr.", "Herr" not "Hr.", "Professor" not "Prof."
- **French**: "Docteur" not "Dr.", "Monsieur" not "M.", "Professeur" not "Prof."
- **Spanish**: "Doctor" not "Dr.", "Señor" not "Sr.", "Profesor" not "Prof."
- **Italian**: "Dottore" not "Dott.", "Signore" not "Sig.", "Professore" not "Prof."

### Organizations
- **English**: "U S A" or "United States" not "USA", "E U" or "European Union" not "EU"
- **German**: "E U" or "Europäische Union" not "EU", "U S A" or "Vereinigte Staaten" not "USA"
- **French**: "U E" or "Union Européenne" not "UE", "É U" or "États-Unis" not "É-U"
- **Spanish**: "U E" or "Unión Europea" not "UE", "E E U U" or "Estados Unidos" not "EEUU"
- **Italian**: "U E" or "Unione Europea" not "UE", "S U A" or "Stati Uniti" not "SUA"

### Technology Terms
- **AI/KI**:
  - English: "A I" or "artificial intelligence"
  - German: "K I" or "künstliche Intelligenz"
  - French: "I A" or "intelligence artificielle"
  - Spanish: "I A" or "inteligencia artificial"
  - Italian: "I A" or "intelligenza artificiale"

- **API**:
  - English: "A P I" or "application programming interface"
  - German: "A P I" or "Programmierschnittstelle"
  - French: "A P I" or "interface de programmation"
  - Spanish: "A P I" or "interfaz de programación"
  - Italian: "A P I" or "interfaccia di programmazione"

### Common Symbols
- **&**: Write out "and" (English), "und" (German), "et" (French), "y" (Spanish), "e" (Italian)
- **#**: Write out "number" (English), "Nummer" (German), "numéro" (French), "número" (Spanish), "numero" (Italian)
- **@**: Write out "at" in all languages
- **%**: Always spell out percentage in words (see Numbers section)

## Dates and Currency

### Dates

Write dates in full words to ensure proper pronunciation.

- **English**: "November twenty-third, two thousand twenty-five" not "23/11/2025" or "Nov 23, 2025"
- **German**: "dreiundzwanzigster November zwanzig hundert fünfundzwanzig" not "23.11.2025"
- **French**: "vingt-trois novembre deux mille vingt-cinq" not "23/11/2025"
- **Spanish**: "veintitrés de noviembre de dos mil veinticinco" not "23/11/2025"
- **Italian**: "ventitre novembre duemilaventicinque" not "23/11/2025"

### Currency

Always write currency values in words with the currency name spelled out.

- **English**:
  - "one hundred dollars" not "$100"
  - "fifty euros" not "€50"
  - "twenty pounds" not "£20"

- **German**:
  - "einhundert Euro" not "100€"
  - "fünfzig Dollar" not "50$"
  - "zwanzig Pfund" not "20£"

- **French**:
  - "cent euros" not "100€"
  - "cinquante dollars" not "50$"
  - "vingt livres" not "20£"

- **Spanish**:
  - "cien euros" not "100€"
  - "cincuenta dólares" not "50$"
  - "veinte libras" not "20£"

- **Italian**:
  - "cento euro" not "100€"
  - "cinquanta dollari" not "50$"
  - "venti sterline" not "20£"

## Units and Measurements

Write all measurements with numbers and units in words.

### Distance and Length

- **English**:
  - "ten kilometers" not "10km"
  - "five meters" not "5m"
  - "three feet" not "3ft"

- **German**:
  - "zehn Kilometer" not "10km"
  - "fünf Meter" not "5m"
  - "drei Fuß" not "3ft"

- **French**:
  - "dix kilomètres" not "10km"
  - "cinq mètres" not "5m"
  - "trois pieds" not "3ft"

- **Spanish**:
  - "diez kilómetros" not "10km"
  - "cinco metros" not "5m"
  - "tres pies" not "3ft"

- **Italian**:
  - "dieci chilometri" not "10km"
  - "cinque metri" not "5m"
  - "tre piedi" not "3ft"

### Volume and Weight

- **English**: "two liters" not "2L", "five kilograms" not "5kg"
- **German**: "zwei Liter" not "2L", "fünf Kilogramm" not "5kg"
- **French**: "deux litres" not "2L", "cinq kilogrammes" not "5kg"
- **Spanish**: "dos litros" not "2L", "cinco kilogramos" not "5kg"
- **Italian**: "due litri" not "2L", "cinque chilogrammi" not "5kg"

### Large Numbers with Units

When combining large numbers with units, write everything in words:

- **English**: "three point seven million subscribers" not "3.7M subscribers"
- **German**: "drei Komma sieben Millionen Abonnenten" not "3,7M Abonnenten"
- **French**: "trois virgule sept millions d'abonnés" not "3,7M abonnés"
- **Spanish**: "tres coma siete millones de suscriptores" not "3,7M suscriptores"
- **Italian**: "tre virgola sette milioni di iscritti" not "3,7M iscritti"

## URLs and Technical Terms

TTS engines cannot meaningfully read URLs or technical identifiers. Describe them instead or omit them entirely.

### URLs

Instead of reading URLs aloud, describe the resource:

- **English**: "on their website" instead of "at https://example.com"
- **German**: "auf ihrer Webseite" instead of "unter https://example.com"
- **French**: "sur leur site web" instead of "à https://example.com"
- **Spanish**: "en su sitio web" instead of "en https://example.com"
- **Italian**: "sul loro sito web" instead of "su https://example.com"

### Email Addresses

Describe the action instead of reading the address:

- **English**: "contact them by email" instead of "email@domain.com"
- **German**: "per E-Mail kontaktieren" instead of "email@domain.com"
- **French**: "les contacter par courriel" instead of "email@domain.com"
- **Spanish**: "contactar por correo electrónico" instead of "email@domain.com"
- **Italian**: "contattarli via email" instead of "email@domain.com"

### Social Media Handles

Describe the platform and username without special characters:

- **English**: "on Twitter as username" instead of "@username"
- **German**: "auf Twitter als Nutzername" instead of "@username"
- **French**: "sur Twitter comme nom d'utilisateur" instead of "@username"
- **Spanish**: "en Twitter como nombre de usuario" instead of "@username"
- **Italian**: "su Twitter come nome utente" instead of "@username"

### Hashtags

Spell out "hashtag" and the term without the # symbol:

- **English**: "hashtag AI coding" instead of "#AICoding"
- **German**: "Hashtag AI Coding" instead of "#AICoding"
- **French**: "hashtag codage I A" instead of "#AICoding"
- **Spanish**: "hashtag programación I A" instead of "#AICoding"
- **Italian**: "hashtag programmazione I A" instead of "#AICoding"

## Best Practices Summary

1. **Always write numbers in words** - Never use digits in dialogue text
2. **Spell out all abbreviations** - TTS engines cannot guess pronunciation
3. **Write dates in full** - Avoid numeric date formats
4. **Include currency names** - Never use currency symbols alone
5. **Describe technical terms** - URLs, emails, and handles should be described
6. **Test pronunciation** - When in doubt, write it how you would say it naturally
7. **Language consistency** - Maintain formatting rules throughout the entire dialogue
8. **Natural flow** - Prioritize how text sounds when spoken over how it looks written
