# Work Plan: [Title]

Created Date: YYYY-MM-DD
Type: feature|fix|refactor
Estimated Impact: X files
Related Issue/PR: #XXX (if any)

## Related Documents
- Design Doc(s):
  - [docs/design/XXX.md]
  - [docs/design/YYY.md] (if multiple, e.g. backend + frontend)
- ADR: [docs/adr/ADR-XXXX.md] (if any)
- PRD: [docs/prd/XXX.md] (if any)

## Objective
[Why this change is necessary, what problem it solves]

## Impact Scope
### Target Files
- [ ] src/domain/xxx
- [ ] src/application/xxx
- [ ] src/infrastructure/xxx
- [ ] src/presentation/xxx

### Test Files
- [ ] __tests__/xxx.test.ts
- [ ] __tests__/xxx.test.ts

### Documentation
- [ ] ADR creation needed (for architecture changes)
- [ ] Design Doc update needed
- [ ] README update needed

## Implementation Plan

(Note: Phase structure is determined based on Design Doc technical dependencies and implementation approach)

### Phase 1: [Phase Name] (Estimated commits: X)
**Purpose**: [What this phase aims to achieve]

#### Tasks
- [ ] Task 1: Specific work content
- [ ] Task 2: Specific work content
- [ ] Quality check: Implement staged quality checks (refer to technical-spec skill)
- [ ] Unit tests: All related tests pass

#### Phase Completion Criteria
- [ ] [Functional completion criteria]
- [ ] [Quality completion criteria]

#### Operational Verification Procedures
1. [Operation verification steps]
2. [Expected result verification]
3. [Performance verification (when applicable)]

### Phase 2: [Phase Name] (Estimated commits: X)
**Purpose**: [What this phase aims to achieve]

#### Tasks
- [ ] Task 1: Specific work content
- [ ] Task 2: Specific work content
- [ ] Quality check: Implement staged quality checks (refer to technical-spec skill)
- [ ] Integration tests: Verify overall feature functionality

#### Phase Completion Criteria
- [ ] [Functional completion criteria]
- [ ] [Quality completion criteria]

#### Operational Verification Procedures
1. [Operation verification steps]
2. [Expected result verification]
3. [Performance verification (when applicable)]

### Phase 3: [Phase Name] (Estimated commits: X)
**Purpose**: [What this phase aims to achieve]

#### Tasks
- [ ] Task 1: Specific work content
- [ ] Task 2: Specific work content
- [ ] Quality check: Implement staged quality checks (refer to technical-spec skill)
- [ ] Integration tests: Verify component coordination

#### Phase Completion Criteria
- [ ] [Functional completion criteria]
- [ ] [Quality completion criteria]

#### Operational Verification Procedures
[Copy relevant integration point E2E verification from Design Doc]

### Final Phase: Quality Assurance (Required) (Estimated commits: 1)
**Purpose**: Overall quality assurance and Design Doc consistency verification

#### Tasks
- [ ] Verify all Design Doc acceptance criteria achieved
- [ ] Quality checks (types, lint, format)
- [ ] Execute all tests
- [ ] Coverage 70%+
- [ ] Document updates

#### Operational Verification Procedures
[Copy E2E verification procedures from Design Doc]

### Quality Assurance
- [ ] Implement staged quality checks (details: refer to technical-spec skill)

## Risks and Countermeasures
| Risk | Countermeasure |
|------|----------------|
| [Expected risk] | [How to address it] |

## Completion Criteria
- [ ] All phases completed
- [ ] Each phase's operational verification procedures executed
- [ ] Design Doc acceptance criteria satisfied
- [ ] Staged quality checks completed (zero errors)
- [ ] All tests pass
- [ ] Necessary documentation updated
- [ ] User review approval obtained

## Progress Tracking
### Phase 1
- Start: YYYY-MM-DD HH:MM
- Complete: YYYY-MM-DD HH:MM
- Notes: [Any special remarks]

### Phase 2
- Start: YYYY-MM-DD HH:MM
- Complete: YYYY-MM-DD HH:MM
- Notes: [Any special remarks]

## Notes
[Special notes, reference information, important points, etc.]
