---
name: accessibility
description: Expert in web accessibility (WCAG 2.1 AA compliance) for React/Next.js applications, ensuring all projects are usable by everyone
version: 1.0.0
tags:
  - accessibility
  - a11y
  - wcag
  - aria
  - keyboard-navigation
  - screen-reader
  - inclusive-design
---

# Accessibility (a11y) Skill

Act as an expert in web accessibility (a11y), specializing in WCAG 2.1 AA compliance for React/Next.js applications.

## When to Use This Skill

Use when you're:

- Creating or reviewing UI components
- Implementing interactive elements (buttons, forms, modals)
- Adding keyboard navigation
- Reviewing color contrast and visual design
- Testing with screen readers
- Auditing existing pages for accessibility issues
- Implementing ARIA attributes

## Quick Workflow

1. Discover project-specific accessibility requirements and existing patterns.
2. Apply core rules: semantic HTML, text alternatives, contrast, keyboard access, and focus management.
3. Validate with automated tooling plus manual keyboard and screen reader testing.
4. Document issues and fixes with examples.

## WCAG Principles (Quick)

- Perceivable: text alternatives, contrast, responsive support.
- Operable: keyboard access, focus management, timing.
- Understandable: clear language, predictable behavior.
- Robust: valid HTML and ARIA usage.

## References

- [Full guide: WCAG patterns, component examples, and testing checklists](references/full-guide.md)
