---
name: brand-architect
description: Use this skill when users need to develop brand strategy, choose a company name, define brand positioning, create brand voice, or build brand identity from day one. Activates for "what should I name it," "brand strategy," "positioning," or identity questions.
version: 1.0.0
tags:
  - business
  - hexa
  - brand
  - naming
  - positioning
  - voice
  - identity
auto_activate: true
---

# Brand Architect - Day-One Brand Strategy

## Overview

Help indie founders build brands that scale using Hexa's "Branding from Day One" methodology. Execute strategic brand development by guiding users through naming, positioning, voice, and visual identity foundations.

**Hexa's Core Principle:** "The name of your business should reflect not only your initial point of entry in the market but also where you aim to be in the future."

## When This Activates

- "What should I name it"
- Brand name questions
- Brand positioning
- Brand voice definition
- Logo, colors, visual identity
- "How do I differentiate"
- Trademark considerations

## The Framework: Brand Architecture Stack

```
┌─────────────────────────────────────────┐
│          BRAND IDENTITY                  │
│    (Logo, Colors, Typography)            │
├─────────────────────────────────────────┤
│           BRAND VOICE                    │
│    (Tone, Language, Personality)         │
├─────────────────────────────────────────┤
│         BRAND POSITIONING                │
│    (Who, What, Why Different)            │
├─────────────────────────────────────────┤
│           BRAND NAME                     │
│    (The Foundation)                      │
└─────────────────────────────────────────┘
```

Build from bottom up: Name → Positioning → Voice → Identity.

## Naming Approaches

| Approach | Example | Best For |
|----------|---------|----------|
| Descriptive | Salesforce | Clear category |
| Evocative | Nike, Apple | Emotional resonance |
| Invented | Spotify | Unique, ownable |
| Founder | Bloomberg | Personal brand |
| Mashup | Instagram | Clever, memorable |

## Name Evaluation (Score 1-5)

- Easy to spell/pronounce
- Memorable
- Domain available
- Trademark-able
- Works at scale
- International friendly

**Minimum score:** 35/50

## Positioning Statement Template

```
For [target customer]
who [problem/need],
[Product Name] is a [category]
that [primary benefit].
Unlike [primary alternative],
we [key differentiator].
```

## Brand Voice Framework

| Dimension | Spectrum |
|-----------|----------|
| Formal ↔ Casual | [Position] |
| Serious ↔ Playful | [Position] |
| Expert ↔ Approachable | [Position] |

## Integration

- `brand-name-generator` - Generate candidates
- `copywriter` - Brand-consistent copy
- `startup-icp-definer` - Define audience
- `micro-landing-builder` - Brand-aligned pages

---

**For complete naming evaluation matrices, positioning maps, voice definition frameworks, visual identity guidelines, color psychology reference, and output templates, see:** `references/full-guide.md`
