# Brand Architect - Full Guide

## The Framework: Brand Architecture Stack

```
┌─────────────────────────────────────────┐
│          BRAND IDENTITY                  │
│    (Logo, Colors, Typography)            │
├─────────────────────────────────────────┤
│           BRAND VOICE                    │
│    (Tone, Language, Personality)         │
├─────────────────────────────────────────┤
│         BRAND POSITIONING                │
│    (Who, What, Why Different)            │
├─────────────────────────────────────────┤
│           BRAND NAME                     │
│    (The Foundation)                      │
└─────────────────────────────────────────┘
```

Build from the bottom up. Name first, then positioning, then voice, then identity.

## Detailed Execution Workflow

### Step 1: Brand Foundation Assessment

Ask the user:

> **What are we naming/branding?**
>
> 1. Is this a company, product, or feature?
> 2. What does it do in one sentence?
> 3. Who is the primary audience?
> 4. What's the category/industry?
> 5. What's your 5-year vision? (Beyond today's product)

**Brand Context:**

| Parameter | Your Answer |
|-----------|-------------|
| Type | [Company/Product/Feature] |
| One-liner | [What it does] |
| Audience | [Who it's for] |
| Category | [Market/Industry] |
| Vision | [Where you're headed] |

### Step 2: Naming Strategy

**The DemoChimp Lesson:** Consensus (formerly DemoChimp) had to rebrand when moving upmarket because "DemoChimp" didn't translate to enterprise. Name for where you're going, not just where you are.

**Naming Approaches:**

| Approach | Example | Best For | Risk |
|----------|---------|----------|------|
| **Descriptive** | Salesforce, LinkedIn | Clear category | Limiting, generic |
| **Evocative** | Nike, Apple | Emotional resonance | Needs more marketing |
| **Invented** | Spotify, Xerox | Unique, ownable | Harder to remember |
| **Founder** | Bloomberg, Tesla | Personal brand | Limited to founder |
| **Acronym** | IBM, BMW | Established brands | Hard to build recognition |
| **Mashup** | Instagram, Pinterest | Clever, memorable | Can feel dated |

**Name Evaluation Criteria:**

| Criterion | Weight | Scoring (1-5) |
|-----------|--------|---------------|
| **Easy to spell** | High | [Score] |
| **Easy to pronounce** | High | [Score] |
| **Memorable** | High | [Score] |
| **Domain available** | High | [Score] |
| **Trademark-able** | High | [Score] |
| **Works at scale** | Medium | [Score] |
| **International friendly** | Medium | [Score] |
| **Category fit** | Medium | [Score] |
| **Differentiated** | Medium | [Score] |
| **Evokes right feeling** | Medium | [Score] |

**Minimum score for consideration:** 35/50

### Step 3: Domain & Trademark Check

**Availability Checklist:**

| Check | Status | Fallback |
|-------|--------|----------|
| [Name].com | [Available/Taken/Purchasable] | [Alternative] |
| @[Name] on X | [Available/Taken] | [Alternative] |
| Trademark (USPTO) | [Clear/Conflict] | [Next steps] |
| Google search clean | [Yes/No] | [Concerns] |
| International meanings | [Checked/Not checked] | [Findings] |

### Step 4: Brand Positioning

**Positioning = Why someone should choose you over alternatives.**

**Positioning Statement Template:**

```
For [target customer]
who [problem/need],
[Product Name] is a [category]
that [primary benefit].
Unlike [primary alternative],
we [key differentiator].
```

**Example:**

```
For B2B sales teams
who struggle with follow-up consistency,
FollowUp Pro is a sales engagement platform
that automates personalized outreach sequences.
Unlike Outreach and Salesloft,
we focus exclusively on small teams under 50 people
with simple pricing and 5-minute setup.
```

### Step 5: Competitive Positioning Map

**Positioning Map Template:**

```
                    High [Dimension 1]
                          │
                          │    ○ Competitor A
                          │
          ○ Competitor B  │        ★ YOU
                          │
  Low [Dim 2] ────────────┼──────────── High [Dim 2]
                          │
                          │    ○ Competitor C
                          │
                    Low [Dimension 1]
```

**Common Positioning Dimensions:**

- Price (Low ↔ Premium)
- Complexity (Simple ↔ Enterprise)
- Scope (Narrow ↔ Broad)
- Speed (Fast ↔ Thorough)
- Touch (Self-serve ↔ High-touch)

### Step 6: Brand Voice Definition

**Brand Voice Framework:**

| Dimension | Your Position |
|-----------|---------------|
| **Formal ↔ Casual** | [Where on spectrum] |
| **Serious ↔ Playful** | [Where on spectrum] |
| **Expert ↔ Approachable** | [Where on spectrum] |
| **Corporate ↔ Rebellious** | [Where on spectrum] |
| **Reserved ↔ Bold** | [Where on spectrum] |

**Voice Traits (Pick 3-5):**

| Trait | What It Means | Example |
|-------|---------------|---------|
| [Trait 1] | [How it shows up] | [Sample sentence] |
| [Trait 2] | [How it shows up] | [Sample sentence] |
| [Trait 3] | [How it shows up] | [Sample sentence] |

**"We are / We are not" Framework:**

| We ARE | We are NOT |
|--------|------------|
| [Trait] | [Opposite] |
| [Trait] | [Opposite] |
| [Trait] | [Opposite] |

### Step 7: Visual Identity Foundations

**Visual Identity Starter:**

| Element | Direction | Rationale |
|---------|-----------|-----------|
| **Primary Color** | [Color] | [Why it fits] |
| **Secondary Color** | [Color] | [How it complements] |
| **Typography Feel** | [Modern/Classic/Playful/Technical] | [Why] |
| **Logo Style** | [Wordmark/Icon/Combo] | [Why] |
| **Overall Aesthetic** | [Minimal/Bold/Warm/Technical] | [Why] |

**Color Psychology Quick Reference:**

| Color | Associations | Best For |
|-------|--------------|----------|
| Blue | Trust, stability, tech | B2B, finance, tech |
| Green | Growth, health, nature | Health, sustainability |
| Red | Energy, urgency, passion | Entertainment, food |
| Orange | Creativity, friendliness | Creative, consumer |
| Purple | Luxury, creativity | Premium, beauty |
| Black | Sophistication, luxury | Premium, fashion |
| White | Simplicity, cleanliness | Tech, minimalist |

## Output Format Template

```markdown
# Brand Strategy: [Brand Name]

## Executive Summary

**Brand Name:** [Name]
**Tagline:** [If applicable]
**Category:** [What category you're in]
**Position:** [One-sentence positioning]

## Brand Foundation

### What We Do
[One paragraph describing the business]

### Who We Serve
[Target customer description]

### Where We're Going
[5-year vision statement]

## Naming

### The Name: [Name]

**Why This Name:**
[Rationale for the name choice]

**Name Score:**

| Criterion | Score (1-5) |
|-----------|-------------|
| Easy to spell | [X] |
| Easy to pronounce | [X] |
| Memorable | [X] |
| Domain available | [X] |
| Trademark-able | [X] |
| Works at scale | [X] |
| International friendly | [X] |
| Category fit | [X] |
| Differentiated | [X] |
| Evokes right feeling | [X] |
| **Total** | **[X]/50** |

### Availability

| Asset | Status |
|-------|--------|
| [Name].com | [Status] |
| @[Name] on X | [Status] |
| Trademark | [Status] |
| Google clean | [Status] |

## Positioning

### Positioning Statement

For [target customer]
who [problem/need],
[Product Name] is a [category]
that [primary benefit].
Unlike [primary alternative],
we [key differentiator].

### Key Differentiators
1. [Differentiator 1]
2. [Differentiator 2]
3. [Differentiator 3]

## Brand Voice

### Personality Traits

Our brand is:
1. **[Trait 1]:** [What this means in practice]
2. **[Trait 2]:** [What this means in practice]
3. **[Trait 3]:** [What this means in practice]

### Voice Spectrum

| Dimension | Our Position |
|-----------|--------------|
| Formal ↔ Casual | [●○○○○ / ○●○○○ / ○○●○○ / ○○○●○ / ○○○○●] |
| Serious ↔ Playful | [●○○○○ / ○●○○○ / ○○●○○ / ○○○●○ / ○○○○●] |
| Expert ↔ Approachable | [●○○○○ / ○●○○○ / ○○●○○ / ○○○●○ / ○○○○●] |

### We Are / We Are Not

| We ARE | We are NOT |
|--------|------------|
| [Trait] | [Opposite] |
| [Trait] | [Opposite] |

### Voice Examples

**How we say hello:**
> "[Example greeting]"

**How we explain our product:**
> "[Example explanation]"

**How we handle errors:**
> "[Example error message]"

## Visual Identity Foundations

### Color Palette

| Role | Color | Hex | Usage |
|------|-------|-----|-------|
| Primary | [Color name] | #XXXXXX | [Where used] |
| Secondary | [Color name] | #XXXXXX | [Where used] |
| Accent | [Color name] | #XXXXXX | [Where used] |

### Typography Direction

| Element | Direction |
|---------|-----------|
| Headlines | [Modern/Classic/Bold/etc.] |
| Body | [Readable/Technical/Friendly/etc.] |

### Logo Direction

**Style:** [Wordmark / Icon / Combination mark]
**Feel:** [Description of desired aesthetic]
**Must convey:** [Key brand attributes]

## Next Steps

### Immediate (This Week)
- [ ] Secure domain: [Name].com
- [ ] Secure social handles
- [ ] Begin trademark search/filing

### Short-Term (30 Days)
- [ ] Create logo
- [ ] Develop full color palette
- [ ] Choose typography
- [ ] Create brand style guide
```

## The Future-Proof Naming Test

Before finalizing a name, ask:

1. **The Expansion Test:** Does it work if you expand to adjacent markets?
2. **The Enterprise Test:** Would Fortune 500 executives take it seriously?
3. **The Cocktail Party Test:** Is it easy to explain and remember?
4. **The Global Test:** Does it work in major international markets?
5. **The 10-Year Test:** Will you still love it in a decade?

## Common Mistakes to Avoid

1. **Naming for today only:** Not considering future expansion
2. **Ignoring trademark:** Discovering conflicts after launch
3. **Copying competitors:** Blending in instead of standing out
4. **Over-designing too early:** Spending on visuals before validation
5. **Inconsistent voice:** Different tone across touchpoints
6. **Vague positioning:** "We're the best" isn't positioning
7. **Skipping research:** Not checking availability before attachment
8. **Too clever:** Names that need explanation

## Brand Audit Checklist

| Element | Status | Action Needed |
|---------|--------|---------------|
| Name works at scale | [✓/✗] | [Action] |
| Domain secured | [✓/✗] | [Action] |
| Trademark filed | [✓/✗] | [Action] |
| Positioning clear | [✓/✗] | [Action] |
| Voice consistent | [✓/✗] | [Action] |
| Visual identity exists | [✓/✗] | [Action] |
| Brand guide documented | [✓/✗] | [Action] |
