---
name: brand-name-generator
description: Generate creative brand names, company names, product names, or startup names. Includes naming strategies, brandability scoring, and domain availability checking.
version: 1.0.0
tags:
  - branding
  - naming
  - startup
  - domain
---

# Brand Name Generator

Generate creative, memorable, and brandable names for companies, products, apps, and startups. Combines naming strategies with brandability scoring and domain availability checking.

## When to Use

- Need creative brand name ideas for a new company or startup
- Want product or app naming suggestions
- Need to brainstorm names based on keywords, concepts, or industry
- Want names evaluated for brandability and memorability
- Need to find available domain names for the brand

## Context Discovery

Before generating names:

1. **Business Context**: Industry, target audience, brand personality
2. **Keywords**: Core concepts, values, emotional associations
3. **Constraints**: Name length, TLD preferences, names to avoid

## Naming Strategies

| Strategy | Description | Examples | Best For |
|----------|-------------|----------|----------|
| **Portmanteau** | Blend two words | Pinterest, Instagram | Apps, social |
| **Invented** | New words | Spotify, Xerox | Tech, premium |
| **Compound** | Join words | Facebook, YouTube | Clear value prop |
| **Misspelling** | Creative respelling | Lyft, Flickr | Startups, apps |
| **Suffix Pattern** | Brand suffixes | Shopify, Grammarly | SaaS, tools |
| **Abstract** | Metaphorical | Amazon, Apple, Uber | Aspirational |

## Popular Suffixes/Prefixes

**Suffixes**: `-ify`, `-ly`, `-io`, `-hub`, `-ment`, `-able`
**Prefixes**: `get-`, `try-`, `go-`, `my-`, `super-`

## Brandability Scoring

Evaluate names on:

- **Memorability**: Shorter = better (1-10)
- **Pronounceability**: Vowel ratio, consonant clusters (1-10)
- **Spellability**: Common patterns, no confusion (1-10)
- **Uniqueness**: Distinctiveness (1-10)
- **Domain Available**: .com bonus

## Validation Checklist

- [ ] Easy to spell when heard
- [ ] Easy to pronounce when read
- [ ] No trademark conflicts
- [ ] No negative connotations in target markets
- [ ] Domain available (preferred TLD)
- [ ] Social handles available

## Quick Workflow

1. Gather context (industry, keywords, constraints)
2. Generate 20-30 candidates using multiple strategies
3. Score brandability
4. Check domain availability
5. Recommend top 3-5 with rationale

---

**For detailed prompt templates, code implementations, and full examples:** `references/full-guide.md`

See also: `references/naming-strategies.md`
