# Brand Naming Strategies Reference

A comprehensive guide to naming strategies with real-world examples and linguistic considerations.

## Strategy Deep Dives

### 1. Portmanteau Names

**Definition:** Blending two words to create a new word that carries meaning from both sources.

**Technique:**

- Identify overlap in sounds between words
- Cut at syllable boundaries for natural flow
- Preserve recognizable elements from each source

**Examples:**

| Brand | Origin | Industry |
|-------|--------|----------|
| Pinterest | Pin + Interest | Social Media |
| Instagram | Instant + Telegram | Social Media |
| Microsoft | Microcomputer + Software | Technology |
| Groupon | Group + Coupon | E-commerce |
| Brangelina | Brad + Angelina | Celebrity |
| Brunch | Breakfast + Lunch | Food |
| Maltesers | Malt + Teasers | Candy |

**Best For:** Apps, social platforms, consumer products where you want to hint at functionality.

**Creation Process:**

```
Word 1: [CONCEPT A] → Break into syllables → Find overlap point
Word 2: [CONCEPT B] → Break into syllables → Find joining point

Example:
- "Network" + "Citizens"
- Net-work + Citi-zens
- Overlap at 't' sound
- Result: "Netizens"
```

---

### 2. Invented Words

**Definition:** Creating entirely new words that have no prior meaning but sound appealing.

**Technique:**

- Use pleasing phonetic combinations
- Blend familiar phonemes in new ways
- Consider international pronunciation

**Phonetic Guidelines:**

| Sound Type | Effect | Examples |
|------------|--------|----------|
| Open vowels (a, o) | Friendly, approachable | Asana, Sonos |
| Soft consonants (l, m, n) | Smooth, premium | Lumina, Monzo |
| Hard consonants (k, t) | Strong, tech-forward | Kodak, Tiktok |
| S/X endings | Modern, tech | Xerox, Nexus |
| -ify endings | Action-oriented | Spotify, Shopify |

**Famous Invented Names:**

| Brand | Origin Story | Industry |
|-------|--------------|----------|
| Kodak | Founder liked letter K, created short punchy word | Photography |
| Xerox | From Greek "xeros" (dry) | Technology |
| Spotify | Mishearing of "spotify" during brainstorm | Music |
| Häagen-Dazs | Made-up "Danish-sounding" name | Ice Cream |
| Acura | Latin "acu" (precision) | Automotive |
| Verizon | Veritas (truth) + Horizon | Telecom |

**Best For:** Tech companies, premium brands, products seeking unique trademark protection.

---

### 3. Abstract/Metaphorical Names

**Definition:** Using existing words with symbolic meaning unrelated to the literal business.

**Categories:**

**Nature:**

| Brand | Meaning/Association | Industry |
|-------|---------------------|----------|
| Amazon | Vast, flowing, everything | E-commerce |
| Apple | Simple, accessible, different | Technology |
| Puma | Speed, agility | Sportswear |
| Jaguar | Power, elegance | Automotive |
| Dove | Gentle, pure | Personal Care |

**Mythology/Literature:**

| Brand | Origin | Industry |
|-------|--------|----------|
| Nike | Greek goddess of victory | Sportswear |
| Pandora | Greek mythology | Jewelry/Music |
| Oracle | Greek prophecy | Technology |
| Atlas | Greek titan | Maps/Data |
| Hermes | Greek messenger god | Fashion |

**Actions/Concepts:**

| Brand | Association | Industry |
|-------|-------------|----------|
| Uber | German for "above/super" | Transportation |
| Zoom | Speed, motion | Video |
| Slack | Relaxed, easy | Productivity |
| Sprint | Fast movement | Telecom |
| Visa | Travel, passage | Finance |

**Best For:** Companies wanting emotional resonance, aspirational positioning, or memorable differentiation.

---

### 4. Compound Words

**Definition:** Joining two complete words to form a descriptive name.

**Types:**

- **Descriptive:** Facebook, YouTube, LinkedIn
- **Benefit-focused:** PayPal, QuickBooks, Salesforce
- **Action-based:** Snapchat, Kickstarter, Dropbox

**Examples:**

| Brand | Components | Why It Works |
|-------|------------|--------------|
| Facebook | Face + Book | Directory concept |
| YouTube | You + Tube | Personal TV |
| LinkedIn | Linked + In | Connected network |
| Snapchat | Snap + Chat | Ephemeral messaging |
| Dropbox | Drop + Box | File storage metaphor |
| WordPress | Word + Press | Publishing tool |
| Mailchimp | Mail + Chimp | Email with personality |

**Best For:** Products where clear value proposition matters, startups needing quick understanding.

---

### 5. Acronyms & Initialisms

**Definition:** Using initials or shortened forms of longer names.

**Famous Acronyms:**

| Acronym | Full Name | Industry |
|---------|-----------|----------|
| IBM | International Business Machines | Technology |
| BMW | Bayerische Motoren Werke | Automotive |
| IKEA | Ingvar Kamprad Elmtaryd Agunnaryd | Retail |
| NASA | National Aeronautics Space Admin | Government |
| ASOS | As Seen On Screen | Fashion |
| GEICO | Government Employees Insurance Co | Insurance |

**Considerations:**

- Works best when acronym is pronounceable (NASA vs IBM)
- May lose meaning without marketing investment
- Harder to trademark single letters
- Risk of conflicting with existing acronyms

**Best For:** Enterprise/institutional brands, companies with long formal names.

---

### 6. Misspelling/Creative Spelling

**Definition:** Intentionally altering spelling for uniqueness or domain availability.

**Techniques:**

- Drop vowels: Flickr, Tumblr, Grindr
- Swap letters: Lyft (Lift), Dribbble
- Add letters: Reddit (Read it), Digg
- Phonetic spelling: Krispy Kreme, Dunkin'

**Examples:**

| Brand | Origin | Change |
|-------|--------|--------|
| Flickr | Flicker | Dropped 'e' |
| Lyft | Lift | y for i |
| Tumblr | Tumbler | Dropped 'e' |
| Reddit | Read It | Phonetic |
| Fiverr | Fiver | Doubled 'r' |
| Scribd | Scribed | Dropped 'e' |

**Risks:**

- Spelling confusion in word-of-mouth
- May appear gimmicky
- SEO challenges with misspellings

**Best For:** Tech startups, apps, when .com of correct spelling is taken.

---

### 7. Suffix/Prefix Patterns

**Definition:** Adding common affixes to base words for brand-like feel.

**Popular Suffixes:**

| Suffix | Meaning/Feel | Examples |
|--------|--------------|----------|
| -ify | "Make into" | Spotify, Shopify, Notify |
| -ly | Adverb, manner | Grammarly, Bitly, Calendly |
| -io | Tech/startup | Twilio, Rubio, Clarifai |
| -hub | Center, collection | GitHub, HubSpot, PornHub |
| -ment | Action, result | Segment, Moment, Implement |
| -able | Capability | Airtable, Workable, Readable |
| -er/-or | Agent, doer | Docker, Tinder, Uber |
| -eo | Action/video | Vimeo, Cameo |
| -ster | Person who | Napster, Friendster |

**Popular Prefixes:**

| Prefix | Meaning | Examples |
|--------|---------|----------|
| get- | Obtain | GetResponse, Getaround |
| go- | Motion | GoDaddy, GoFundMe |
| my- | Personal | MySpace, MyFitnessPal |
| i- | Personal/Apple | iPhone, iCloud |
| e- | Electronic | eBay, eHarmony |
| super- | Enhanced | Superhuman, Supercell |
| meta- | Beyond | Meta, Metabase |
| neo- | New | NeoBank, Neopets |

---

### 8. Founder/Personal Names

**Definition:** Using founder names or personal names as brand identity.

**Examples:**

| Brand | Founder(s) | Industry |
|-------|------------|----------|
| Ford | Henry Ford | Automotive |
| Disney | Walt Disney | Entertainment |
| Dell | Michael Dell | Technology |
| Bloomberg | Michael Bloomberg | Finance |
| Chanel | Coco Chanel | Fashion |
| Burberry | Thomas Burberry | Fashion |
| Ferrari | Enzo Ferrari | Automotive |
| Hewlett-Packard | Bill Hewlett & Dave Packard | Technology |

**Considerations:**

- Creates personal connection and accountability
- May limit company's ability to evolve beyond founder
- Succession challenges if founder leaves
- Strong for luxury and personal service brands

---

## Industry-Specific Patterns

### Tech/SaaS

- Short, punchy (Slack, Zoom, Figma)
- Invented words ending in -a (Asana, Jira, Mira)
- Abstract single words (Notion, Linear, Craft)
- -ify suffix (Spotify, Shopify, Calendly)

### Fintech

- Trust/stability words (Stripe, Square, Plaid)
- Compound with "Pay" (PayPal, Afterpay, Razorpay)
- Short invented (Klarna, Monzo, Chime)

### Health/Wellness

- Nature references (Calm, Headspace)
- Growth/life metaphors (Noom, Hims)
- Clean, simple sounds (Peloton, Whoop)

### E-commerce/Retail

- Marketplace metaphors (Amazon, eBay, Etsy)
- Product focus (Warby Parker, Casper)
- Quirky/memorable (Zappos, Chewy)

### AI/ML

- Intelligence references (DeepMind, OpenAI)
- -ai suffix (Clarifai, Copy.ai)
- Scientific terms (Anthropic, Cohere)

---

## Linguistic Considerations

### Phonetic Appeal

**Pleasing Sound Combinations:**

- Liquid consonants (l, r): Lyra, Lumen
- Nasal consonants (m, n): Nimbus, Mono
- Open vowels (a, o): Sonos, Asana

**Sounds to Avoid:**

- Difficult clusters: str-, scr-, thr-
- Harsh stops at end: -ck, -tch
- Ambiguous pronunciation: "gh", "ough"

### International Considerations

**Check for:**

- Negative meanings in target markets
- Pronunciation difficulties (Chinese speakers, Spanish speakers)
- Cultural taboos or associations
- Existing trademarks in expansion markets

**Famous Fails:**

- Chevy Nova in Spanish ("no va" = "doesn't go")
- IKEA product names (Fartfull, Gosa Ransen)
- Mitsubishi Pajero in Spanish (slang for inappropriate term)

### Syllable Patterns

**Optimal:** 2-3 syllables for memorability

| Syllables | Examples | Notes |
|-----------|----------|-------|
| 1 | Zoom, Slack, Stripe | Punchy, memorable |
| 2 | Apple, Google, Meta | Sweet spot |
| 3 | Amazon, Spotify | Still good |
| 4+ | Alibaba | Harder to remember |

---

## Trademark & Legal Considerations

### Before Finalizing

1. **USPTO Search:** Check US trademark database
2. **State Registrations:** Check state-level marks
3. **Domain Availability:** Verify .com and key TLDs
4. **Social Handles:** Check Twitter, Instagram, Facebook
5. **International Marks:** If expanding globally
6. **Common Law Search:** Unregistered but established uses

### Protectable Names

- **Strongest:** Invented words (Xerox, Kodak)
- **Strong:** Arbitrary (Apple for computers)
- **Moderate:** Suggestive (Netflix suggests movies)
- **Weak:** Descriptive (General Electric)
- **Unprotectable:** Generic (Computer Store)

---

## Quick Reference: Naming Checklist

### Generation Phase

- [ ] Explored 3+ naming strategies
- [ ] Generated 20+ candidates
- [ ] Considered multiple languages
- [ ] Tested pronunciation aloud

### Evaluation Phase

- [ ] Scored brandability (memorability, pronounceability, spellability)
- [ ] Checked .com domain availability
- [ ] Verified social media handles
- [ ] Searched trademark databases

### Validation Phase

- [ ] No negative meanings in target markets
- [ ] Easy to spell when heard
- [ ] Easy to say when read
- [ ] Scales with company growth
- [ ] Unique in competitive landscape
