---
name: channel-validator
description: Use this skill when users need to validate their marketing channel strategy, assess channel focus, or determine lead gen priorities. Activates for "validate my channels," "am I on the right platforms," "should I focus on X or Y channel," or when assessing marketing spread.
version: 1.0.0
tags:
  - business
  - hormozi
  - validation
  - channels
  - lead-gen
  - marketing
  - focus
auto_activate: true
---

# Channel Validator - One Channel Rule Scorecard

Validate channel strategy against Hormozi's One Channel Rule—master one before adding more.

**Core Principle:** "One avatar, one channel, one offer. Master it before you add."

## When This Activates

- User asks "validate my channels"
- User asks "am I on the right platforms"
- User asks "should I focus on X or Y"
- User says "I'm doing X, Y, Z, A, B..."
- User says "nothing is working"
- User mentions being "everywhere"

## The Framework

```
One Channel + One Avatar + One Offer = Mastery → Then Expand
```

### Scoring Dimensions

| Dimension | Weight | What It Measures |
|-----------|--------|------------------|
| Channel Focus | 2x | Focused or spread thin? |
| Channel Mastery | 2x | Mastered primary channel? |
| Avatar Clarity | 1.5x | Crystal clear customer? |
| ROI Awareness | 1.5x | Know what's working? |
| Expansion Readiness | 1x | Ready for channel #2? |

**Max Score:** 100 points

### Rating Scale

| Score | Rating | Verdict |
|-------|--------|---------|
| 85-100 | Focused & Ready | Scale primary, consider expansion |
| 70-84 | Good Focus | Continue mastering, don't add |
| 55-69 | Needs Focus | Cut channels, double down |
| 40-54 | Sprawled | Major consolidation needed |
| 0-39 | Scattered | Stop everything, pick ONE |

## Channel Sprawl Signs

- Active on 5+ platforms
- Adding new channels before mastering any
- "Repurposing content everywhere"
- No channel getting full attention
- Constantly switching strategies

## Focus Test

> If you could only use ONE channel for the next 6 months, which would it be?

If they struggle to answer, focus is the problem.

## Integration

| Skill | When to Use |
|-------|-------------|
| `lead-channel-optimizer` | Optimize chosen channel |
| `traffic-validator` | Validate traffic strategy |
| `traffic-architect` | Design traffic strategy |
| `offer-validator` | Validate offer for channel |

---

**For detailed scoring criteria, output templates, and mastery indicators:** `references/full-guide.md`
