# Channel Validator - Full Guide

Complete guide to validating channel strategy using the One Channel Rule framework.

## Step 1: Gather Channel Strategy

Ask the user:

> **Tell me about your marketing channels:**
>
> 1. What channels are you currently using to get customers?
> 2. How long have you been on each channel?
> 3. Which channel brings the most customers/revenue?
> 4. How much time/money do you spend on each?
> 5. What's your customer acquisition cost by channel?
> 6. Who is your ideal customer? (One sentence)

## Scoring Criteria

### Channel Focus (0-10, Weight: 2x)

Evaluate if they're **focused or spread thin**:

- How many channels are they **actively using**?
- Is there **one primary channel** with others supporting?
- Are they adding channels before **mastering current ones**?
- Is there **shiny object syndrome**?
- Could they **cut channels** without losing much?

| Score | Description |
|-------|-------------|
| 9-10 | One primary channel, fully focused, supporting activities aligned |
| 7-8 | 1-2 channels, clear primary, good focus |
| 5-6 | 3 channels, some sprawl, but primary exists |
| 3-4 | 4+ channels, spread thin, no clear primary |
| 0-2 | Everywhere, scattered, no focus at all |

**Channel Sprawl Signs:**

- Active on 5+ platforms
- Adding new channels before mastering any
- "Repurposing content everywhere"
- No channel getting full attention
- Constantly switching strategies

**Focus Test:**
> If you could only use ONE channel for the next 6 months, which would it be?

If they struggle to answer, focus is the problem.

### Channel Mastery (0-10, Weight: 2x)

Evaluate if they've **mastered their primary channel**:

- Do they know the **mechanics** deeply?
- Are they getting **consistent results**?
- Have they **optimized** the channel?
- Could they **teach** someone else?
- Are they in the **top 10%** of practitioners?

| Score | Description |
|-------|-------------|
| 9-10 | Deep mastery, consistent results, could teach others |
| 7-8 | Good understanding, regular results, still optimizing |
| 5-6 | Moderate knowledge, inconsistent results |
| 3-4 | Basic use, learning stage, poor results |
| 0-2 | Beginner, no understanding, no results |

**Mastery Indicators:**

| Beginner | Intermediate | Master |
|----------|--------------|--------|
| Posting randomly | Content calendar | Algorithmic understanding |
| No analytics | Tracking some metrics | Deep attribution |
| Copying others | Developing voice | Own methodology |
| Hoping for results | Some predictability | Predictable outcome |

**Mastery Questions:**

- What's your average engagement rate?
- What's your conversion rate from channel?
- What content type performs best?
- What's your posting/outreach frequency?
- What would you change to 2x results?

### Avatar Clarity (0-10, Weight: 1.5x)

Evaluate if they **know their customer**:

- Can they describe ideal customer in **one sentence**?
- Do they know where this customer **hangs out**?
- Is their messaging **tailored** to this avatar?
- Have they **talked to** actual customers?
- Is there **one avatar** or multiple?

| Score | Description |
|-------|-------------|
| 9-10 | Crystal clear avatar, one sentence description, knows exactly where they are |
| 7-8 | Good clarity, clear description, knows general hangouts |
| 5-6 | Somewhat clear, could be more specific |
| 3-4 | Vague avatar, or multiple competing avatars |
| 0-2 | "Everyone" is the target |

**Avatar Clarity Test:**
> Describe your ideal customer in one sentence with specific demographics and psychographics.

**Red Flags:**

- "Anyone who needs X"
- Multiple very different avatars
- Haven't talked to actual customers
- Guessing at where they hang out

### ROI Awareness (0-10, Weight: 1.5x)

Evaluate if they **know what's working**:

- Do they know **CAC by channel**?
- Do they track **where customers come from**?
- Do they know **which content/campaigns** work?
- Can they calculate **ROI per channel**?
- Are decisions **data-driven** or gut-based?

| Score | Description |
|-------|-------------|
| 9-10 | Full attribution, knows CAC by channel, ROI calculated |
| 7-8 | Good tracking, knows top performers |
| 5-6 | Some tracking, general sense of what works |
| 3-4 | Minimal tracking, mostly guessing |
| 0-2 | No idea what's working |

**Metrics to Know:**

| Metric | Why It Matters |
|--------|----------------|
| CAC by channel | Know where to invest |
| LTV by channel | Not all customers equal |
| Conversion rate | Measure effectiveness |
| Time investment | Opportunity cost |
| Content performance | What resonates |

**Red Flags:**

- "I think this is working"
- No UTM parameters or tracking
- Don't know where customers came from
- Making decisions without data

### Expansion Readiness (0-10, Weight: 1x)

Evaluate if they're **ready for channel #2**:

- Is primary channel **mastered** (7+ on mastery)?
- Is primary channel **systematized** (could delegate)?
- Are results **predictable and consistent**?
- Do they have **capacity** for another channel?
- Is the next channel **strategically chosen**?

| Score | Description |
|-------|-------------|
| 9-10 | Primary mastered and systematized, clear strategy for #2 |
| 7-8 | Primary working well, capacity emerging |
| 5-6 | Getting results but not systematized |
| 3-4 | Still figuring out primary |
| 0-2 | Not even close to ready |

**Expansion Checklist:**

- [ ] Primary channel generating consistent leads
- [ ] Process documented
- [ ] Could be delegated
- [ ] Results predictable month-over-month
- [ ] Clear reason for next channel
- [ ] Next channel complements primary

## Score Calculation

```
Channel Focus × 2 = ___
Channel Mastery × 2 = ___
Avatar Clarity × 1.5 = ___
ROI Awareness × 1.5 = ___
Expansion Readiness × 1 = ___
─────────────────────────
TOTAL = ___ / 100
```

## Output Template

```markdown
# Channel Validation: [Business Name]

## Quick Rating

| Rating | Score | Verdict |
|--------|-------|---------|
| [Focused / Good / Needs Focus / Sprawled / Scattered] | XX/100 | [One-line summary] |

## Channel Assessment

**Current Channels:**
| Channel | Time/Week | Results | CAC |
|---------|-----------|---------|-----|
| [Channel 1] | Xh | [Result] | $X |
| [Channel 2] | Xh | [Result] | $X |

**Recommended Primary:**
> [One channel to focus on]

**Cut List:**
- [Channel to cut]
- [Channel to cut]

## Score Breakdown

| Dimension | Raw Score | Weight | Weighted Score | Status |
|-----------|-----------|--------|----------------|--------|
| Channel Focus | X/10 | ×2 | XX/20 | [Focus/Cut/Strong] |
| Channel Mastery | X/10 | ×2 | XX/20 | [Learn/Improve/Strong] |
| Avatar Clarity | X/10 | ×1.5 | XX/15 | [Define/Clarify/Strong] |
| ROI Awareness | X/10 | ×1.5 | XX/15 | [Track/Measure/Strong] |
| Expansion Readiness | X/10 | ×1 | XX/10 | [Wait/Prepare/Ready] |
| **TOTAL** | | | **XX/100** | |

## Detailed Assessment

### Channel Focus: X/10
**Current Spread:** [How many channels]
**Problem:** [Why spread is hurting]
**Fix:** [Specific consolidation action]

### Channel Mastery: X/10
**Primary Channel:** [Their main channel]
**Mastery Level:** [Beginner/Intermediate/Master]
**To Improve:** [Specific mastery actions]

### Avatar Clarity: X/10
**Current Avatar:** [Their description]
**Sharpened Avatar:** [More specific version]
**Where They Are:** [Channel where avatar hangs out]

### ROI Awareness: X/10
**What They Track:** [Current metrics]
**Should Track:** [Missing metrics]
**Set Up:** [Specific tracking to add]

### Expansion Readiness: X/10
**Status:** [Ready/Not Ready]
**Before Expansion:** [What needs to happen first]
**Next Channel:** [Recommended next channel when ready]

## The One Channel Plan

For the next 90 days:
1. **Focus On:** [One channel]
2. **Cut:** [Channels to stop]
3. **Master:** [Specific skills to develop]
4. **Track:** [Metrics to monitor]
5. **Goal:** [Specific outcome target]

## Next Steps

### If Score 85+:
- [ ] Systematize primary channel
- [ ] Document processes
- [ ] Consider channel #2 strategically

### If Score 70-84:
- [ ] Continue mastering primary
- [ ] Resist adding channels
- [ ] Improve tracking

### If Score 55-69:
- [ ] Cut to 1-2 channels
- [ ] Focus on mastery
- [ ] Use `lead-channel-optimizer` for optimization

### If Score Below 55:
- [ ] Stop all channels except ONE
- [ ] 90-day single channel focus
- [ ] Track everything
```
