---
name: cofounder-evaluator
description: Use this skill when users need to evaluate potential co-founders, assess founder compatibility, design equity splits, or navigate co-founder relationships. Activates for "should I work with this person," "co-founder fit," "equity split," or founding team questions.
version: 1.0.0
tags:
  - business
  - hexa
  - cofounder
  - team
  - equity
  - partnership
  - founding
auto_activate: true
---

# Co-Founder Evaluator - Founding Team Assessment

## Overview

Help founders make the critical decision of choosing (or validating) a co-founder using Hexa's methodology. Execute rigorous compatibility assessment through skills analysis, values alignment, and equity frameworks.

**Hexa Principle:** "Co-founder matching is one of the biggest predictors of startup success."

## When This Activates

- "Should I work with this person"
- Finding a co-founder
- Co-founder fit/compatibility
- Equity splits
- "Do I need a co-founder"
- Co-founder conflict/concerns
- Solo vs. partnering

## Evaluation Stack (Bottom Up)

1. **Skills Complement** - What each brings
2. **Vision Alignment** - Where you want to go
3. **Values Alignment** - What you believe matters
4. **Working Style** - How you collaborate daily

## Solo vs. Co-founder

| Favors Solo | Favors Co-founder |
|-------------|-------------------|
| 80%+ skills covered | Major skill gaps |
| Move fast alone | Need parallel execution |
| Prefer autonomy | Value debate/input |
| Strong network | Need complementary network |
| Bootstrapping | Raising (investors like teams) |

**5+ either way:** Follow that direction

## Skills Matrix

Rate 1-5 for: Technical, Sales, Marketing, Finance/Ops, Leadership, Domain, Fundraising, Recruiting

**Ideal:** No overlaps >4, no gaps <2

## Founder Archetypes

| Type | Best Paired With |
|------|------------------|
| Builder | Seller or Operator |
| Seller | Builder or Operator |
| Operator | Builder or Seller |
| Visionary | Executor |

## Vision Alignment Questions

- 5-year vision?
- Company size goal?
- Exit preference ($10M vs $1B)?
- Time commitment?

**Red Flag:** Different answers = discuss before proceeding

## Trial Period (8-12 weeks)

1. Coffee chats (2-4 weeks)
2. Mini project (2-4 weeks)
3. Full immersion (4-8 weeks)
4. Decision

**Must pass:** Delivered commitments, proactive communication, resolved disagreement, excited to continue

## Equity Split Rules

- When in doubt: 50/50
- Always vest (4yr/1yr cliff)
- Get it in writing

| Situation | Split |
|-----------|-------|
| Equal contribution | 50/50 |
| Idea + domain vs. execution | 55/45 - 60/40 |
| Full-time vs. part-time | 60/40 - 70/30 |

## Red Flags (Stop)

- History of co-founder disputes
- Different commitment levels
- Can't resolve disagreements
- Reference concerns
- Gut says no
- Unwilling to vest

## The 7-10 Year Question

> "Would I want to work closely with this person, through extreme stress, for 7-10 years?"

If not enthusiastic yes, keep looking.

## Integration

- `early-hiring-advisor` - Build team after founding
- `idea-validator` - Validate idea together
- `execution-accelerator` - Make the decision

---

**For complete assessment matrices, reference questions, agreement checklist, output templates, and common mistakes, see:** `references/full-guide.md`
