# Co-Founder Evaluator - Full Guide

## The Framework: Co-Founder Evaluation Stack

```
+----------------------------------------+
|         WORKING STYLE                   |
|    (How you collaborate daily)          |
+----------------------------------------+
|         VALUES ALIGNMENT                |
|    (What you believe matters)           |
+----------------------------------------+
|         VISION ALIGNMENT                |
|    (Where you want to go)               |
+----------------------------------------+
|         SKILLS COMPLEMENT               |
|    (What each brings)                   |
+----------------------------------------+
```

Evaluate from bottom up. Skills first, then vision, then values, then working style.

## Detailed Execution Workflow

### Step 1: Solo vs. Co-founder Framework

| Factor | Favors Solo | Favors Co-founder |
|--------|-------------|-------------------|
| Skills | You have 80%+ of what's needed | Major skill gaps |
| Speed | Can move fast alone | Need parallel execution |
| Decision-making | Prefer autonomy | Value debate/input |
| Risk | Can handle alone | Need shared burden |
| Network | Strong existing network | Need complementary network |
| Motivation | Self-driven | Need accountability partner |
| Capital | Bootstrapping | Raising (investors like teams) |

**Recommendation:**

- **5+ factors favor solo:** Consider going alone
- **5+ favor co-founder:** Find the right partner
- **Split:** Either works—go with your gut

### Step 2: Skills Matrix

| Skill Area | You | Them | Coverage |
|------------|-----|------|----------|
| **Technical/Product** | [1-5] | [1-5] | [Gap/Overlap/Covered] |
| **Sales/GTM** | [1-5] | [1-5] | [Gap/Overlap/Covered] |
| **Marketing** | [1-5] | [1-5] | [Gap/Overlap/Covered] |
| **Finance/Ops** | [1-5] | [1-5] | [Gap/Overlap/Covered] |
| **Leadership/Mgmt** | [1-5] | [1-5] | [Gap/Overlap/Covered] |
| **Domain Expertise** | [1-5] | [1-5] | [Gap/Overlap/Covered] |
| **Fundraising** | [1-5] | [1-5] | [Gap/Overlap/Covered] |
| **Recruiting** | [1-5] | [1-5] | [Gap/Overlap/Covered] |

**Ideal:**

- **Zero overlaps > 4:** No wasted overlap
- **Zero gaps < 2:** All critical areas covered
- **Complementary strengths:** Each leads different areas

**Common Founder Archetypes:**

| Archetype | Strengths | Best Paired With |
|-----------|-----------|------------------|
| **Builder** | Product, engineering, design | Seller or Operator |
| **Seller** | Sales, BD, fundraising | Builder or Operator |
| **Operator** | Finance, ops, process | Builder or Seller |
| **Visionary** | Strategy, storytelling | Executor |
| **Executor** | Getting things done | Visionary |

### Step 3: Vision Alignment Matrix

| Question | You | Them | Aligned? |
|----------|-----|------|----------|
| 5-year vision | [Answer] | [Answer] | [Y/N/Discuss] |
| Company size goal | [Answer] | [Answer] | [Y/N/Discuss] |
| Exit preference | [Answer] | [Answer] | [Y/N/Discuss] |
| Risk tolerance | [Answer] | [Answer] | [Y/N/Discuss] |
| Time commitment | [Answer] | [Answer] | [Y/N/Discuss] |
| Work-life balance | [Answer] | [Answer] | [Y/N/Discuss] |

**Red Flags:**

- One wants $10M exit, other wants $1B
- Different commitment levels (full-time vs. part-time)
- Disagreement on company culture/values
- Different timelines for success

### Step 4: Values Assessment

| Value | Your Priority (1-5) | Their Priority (1-5) | Gap |
|-------|---------------------|----------------------|-----|
| Integrity | [X] | [X] | [±X] |
| Speed/Urgency | [X] | [X] | [±X] |
| Quality/Craft | [X] | [X] | [±X] |
| Work-life balance | [X] | [X] | [±X] |
| Financial success | [X] | [X] | [±X] |
| Impact/Mission | [X] | [X] | [±X] |
| Team/Culture | [X] | [X] | [±X] |
| Customer focus | [X] | [X] | [±X] |

**Warning Zone:** Any gap > 2 points needs discussion.

**Core Values Questions:**

| Scenario | Their Answer | Concerning? |
|----------|--------------|-------------|
| "Would you take a salary cut if needed?" | [Answer] | [Y/N] |
| "How do you handle bad news?" | [Answer] | [Y/N] |
| "What if we disagree on direction?" | [Answer] | [Y/N] |
| "How important is control to you?" | [Answer] | [Y/N] |
| "What would make you walk away?" | [Answer] | [Y/N] |

### Step 5: Working Style Matrix

| Dimension | You | Them | Compatible? |
|-----------|-----|------|-------------|
| Work hours | [Pattern] | [Pattern] | [Y/N/Flex] |
| Location | [Preference] | [Preference] | [Y/N/Flex] |
| Communication | [Style] | [Style] | [Y/N/Flex] |
| Decision-making | [Fast/Deliberate] | [Fast/Deliberate] | [Y/N/Flex] |
| Conflict style | [Style] | [Style] | [Y/N/Flex] |
| Feedback style | [Direct/Gentle] | [Direct/Gentle] | [Y/N/Flex] |
| Stress response | [Response] | [Response] | [Y/N/Flex] |

**Critical Compatibility:**

- Decision-making style
- Conflict resolution approach
- Communication frequency

### Step 6: Trial Period Framework

| Phase | Duration | Goal |
|-------|----------|------|
| **Coffee chats** | 2-4 weeks | Get to know each other |
| **Mini project** | 2-4 weeks | Work on something together |
| **Full immersion** | 4-8 weeks | Work like co-founders daily |
| **Decision** | After 8-12 weeks | Commit or part ways |

**Trial Period Questions:**

| After Trial | Assessment |
|-------------|------------|
| Did they deliver what they committed? | [Y/N] |
| Did they communicate proactively? | [Y/N] |
| Did you resolve a disagreement? | [Y/N] |
| Would you want to do this for 7-10 years? | [Y/N] |
| Are you excited to work with them? | [Y/N] |

**All 5 must be Yes to proceed.**

### Step 7: Reference Questions

| Question | Why It Matters |
|----------|----------------|
| "What's it like to work with them?" | General impression |
| "How do they handle stress?" | Startup reality |
| "How do they handle disagreement?" | Conflict style |
| "What's their biggest weakness?" | Self-awareness |
| "Would you work with them again?" | True signal |
| "What should I know before partnering?" | Red flags |

### Step 8: Equity Split Framework

**Equity Factors:**

| Factor | Weight | You | Them |
|--------|--------|-----|------|
| Idea origination | 5% | [%] | [%] |
| Domain expertise | 15% | [%] | [%] |
| Technical execution | 25% | [%] | [%] |
| Business/Sales | 25% | [%] | [%] |
| Capital contributed | 10% | [%] | [%] |
| Risk taken | 10% | [%] | [%] |
| Network/connections | 10% | [%] | [%] |

**Common Splits:**

| Situation | Typical Split |
|-----------|---------------|
| Equal contribution, equal risk | 50/50 |
| One has idea + domain, other executes | 55/45 or 60/40 |
| One full-time, one part-time | 60/40 to 70/30 |
| Significant capital contribution | Adjust 5-15% |

**Rules of Thumb:**

- When in doubt, go 50/50
- Small differences (55/45) often cause more resentment than they're worth
- Vesting solves the "what if they leave" problem

### Step 9: Vesting Structure

**Standard Vesting:**

```
Year 1 (Cliff): 0% vested -> 25% vests at 12 months
Year 2: 25% -> 50% (monthly vesting)
Year 3: 50% -> 75% (monthly vesting)
Year 4: 75% -> 100% (monthly vesting)
```

**Vesting Scenarios:**

| If They Leave... | They Keep | Unvested Equity |
|------------------|-----------|-----------------|
| Before cliff (< 12 months) | Nothing | Returns to company |
| At 18 months | ~31% | Returns to company |
| At 2 years | 50% | Returns to company |
| At 3 years | 75% | Returns to company |
| After 4 years | 100% | Fully vested |

### Step 10: Co-Founder Agreement Checklist

| Item | Agreed? | Details |
|------|---------|---------|
| Equity split | [Y/N] | [X%/Y%] |
| Vesting schedule | [Y/N] | [Terms] |
| Roles and responsibilities | [Y/N] | [Who does what] |
| Decision-making process | [Y/N] | [How you'll decide] |
| Salary/compensation | [Y/N] | [Initial terms] |
| IP assignment | [Y/N] | [All work belongs to company] |
| Non-compete terms | [Y/N] | [Terms] |
| Exit/departure terms | [Y/N] | [What happens if someone leaves] |
| Dispute resolution | [Y/N] | [How you'll handle conflicts] |

## Red Flags Checklist

**Stop if you see:**

- [ ] History of co-founder disputes
- [ ] Different commitment levels (full vs. part-time)
- [ ] Vastly different exit expectations
- [ ] Can't resolve disagreements constructively
- [ ] Reference checks reveal concerns
- [ ] Gut feeling says no (trust it)
- [ ] Pressure to decide quickly
- [ ] Unwilling to vest equity
- [ ] Major values misalignment
- [ ] Poor communication in trial period

## Common Mistakes to Avoid

1. **Rushing the decision:** Take 2-3 months minimum
2. **Skipping the trial:** Always work together first
3. **Ignoring red flags:** They don't get better
4. **Equal split without discussion:** 50/50 needs to be intentional
5. **No vesting:** Always vest equity
6. **Verbal agreements:** Get it in writing
7. **Same skills:** Complement, don't duplicate
8. **Friendship bias:** Friends make good friends, not always good co-founders
9. **Desperation:** Bad co-founder > good solo founder is wrong
10. **Ignoring references:** Talk to people who know them

## The 7-10 Year Question

Before committing, ask yourself:

> "Would I want to work closely with this person, through extreme stress, for the next 7-10 years?"

If the answer isn't an enthusiastic yes, keep looking.
