---
name: content-creator
description: Expert content creator specializing in newsletters and tweets that capture your authentic voice. Creates engaging, on-brand content for newsletters and social media (X/Twitter) that reflects your unique style and tone. Activates when users want to create newsletters, tweets, social media content, or content lineups.
version: 1.0.0
tags:
  - content-creation
  - newsletter
  - social-media
  - twitter
  - brand-voice
  - content-strategy
license: Complete terms in LICENSE.txt
---

# Content Creator Skill

Expert content creator specializing in newsletters and tweets that authentically capture the user's voice and brand.

**Core Principle:** "Write like you're talking to a friend, not a corporation."

## When This Activates

- User wants to create newsletters or email content
- User needs to write tweets or X posts
- User requests social media content
- User asks for content lineups or calendars
- User wants content that matches their voice

## Quick Reference

### Content Types

| Type | Format | Best For |
|------|--------|----------|
| Newsletter | Email, long-form | Updates, insights, value delivery |
| Tweet | Short-form, 280 chars | Quick updates, engagement |
| Thread | Multi-tweet series | Longer insights, stories |
| Content Lineup | Planning doc | Calendar, strategy |

### Voice Discovery Checklist

- [ ] Check `.agents/SYSTEM/ARCHITECTURE.md` for brand guidelines
- [ ] Review existing newsletters/tweets for patterns
- [ ] Look for brand voice documentation
- [ ] Identify target audience from project docs

### Newsletter Structure

| Section | Purpose |
|---------|---------|
| Subject Line | Hook, clear value |
| Opening | Personal connection |
| Main Content | Updates, insights, value |
| Call-to-Action | Clear next steps |
| Closing | Personal sign-off |

### Tweet Types

| Type | Example Use |
|------|-------------|
| Updates | Project progress, launches |
| Insights | Learnings, tips, observations |
| Questions | Engage audience, feedback |
| Resources | Links, tools, recommendations |
| Stories | Behind-the-scenes |

### Content Mix Guidelines

| Category | Recommended % |
|----------|---------------|
| Educational | 40% |
| Updates | 30% |
| Engagement | 20% |
| Promotional | 10% |

## Integration

| Skill | When to Use |
|-------|-------------|
| `copywriter` | Brand voice consistency |
| `strategy-expert` | Content strategy planning |
| `planning-assistant` | Content calendar management |

## Complementary Skills (External)

For social media tactics and templates, pair with [coreyhaines31/marketingskills](https://github.com/coreyhaines31/marketingskills):

```
/plugin marketplace add coreyhaines31/marketingskills
```

| Skill | Why |
|-------|-----|
| `social-content` | Social media content templates and tactics |

---

**For detailed workflows, examples, and content lineup generation:** `references/full-guide.md`
