# Content Creator - Full Guide

Complete guide to creating newsletters, tweets, and content lineups that capture authentic brand voice.

## Project Context Discovery

**Before creating content, discover the project's brand voice and context:**

### Step 1: Scan Project Documentation

- Check `.agents/SYSTEM/ARCHITECTURE.md` for brand guidelines
- Look for brand voice documentation in project docs
- Review `.agents/SOP/` for content standards
- Check for existing content examples (newsletters, tweets, social posts)

### Step 2: Identify Brand Voice

- Review existing newsletters and social media posts
- Check for brand voice guidelines or style guides
- Look for tone documentation (formal, casual, technical, humorous, etc.)
- Identify target audience from project docs
- Analyze writing patterns and voice characteristics

### Step 3: Use Project-Specific Skills

- Check for `[project]-copywriter` or `[project]-content-creator` skill
- Look for project-specific brand voice documentation
- Review project's content patterns and examples

### Step 4: Adapt to Project Voice

- Match discovered brand voice and tone
- Use project's terminology and style
- Follow project's content conventions
- Maintain consistency with existing content

## Content Creation Principles

### Voice & Tone

**Core Principles (discover from project):**

- Adapt to project's brand voice (formal, casual, technical, humorous, etc.)
- Match project's tone (direct, friendly, professional, conversational, etc.)
- Use project's terminology and style
- Follow project's value proposition style
- Align with project's target audience
- Maintain authenticity and personal voice

**Default Voice (if no brand voice found):**

- **Authentic**: Write like you're talking to a friend, not a corporation
- **Clear & Direct**: Get to the point quickly, no fluff
- **Value-first**: Lead with what matters to the audience
- **Engaging**: Use stories, examples, and relatable content

## Newsletter Creation

### Newsletter Structure

1. **Subject Line** (discover project's style):
   - Match project's subject line patterns
   - Clear, compelling, and on-brand
   - Avoid clickbait unless it matches project style

2. **Opening** (Hook):
   - Personal connection or story
   - Relevant to audience
   - Sets the tone for the newsletter

3. **Main Content**:
   - Organized sections with clear headings
   - Mix of updates, insights, and value
   - Project-specific content and updates
   - Personal voice and perspective

4. **Call-to-Action**:
   - Clear next steps
   - Match project's CTA style
   - Relevant to content

5. **Closing**:
   - Personal sign-off
   - Match project's closing style
   - Consistent with brand voice

### Newsletter Best Practices

- Keep it scannable (headings, bullet points, short paragraphs)
- Mix content types (updates, insights, resources, stories)
- Include project-specific context and updates
- Maintain consistent voice throughout
- Add value in every section

### Newsletter Example Structure

```
Subject: [Discover from project style]

Hey [Audience],

[Personal opening/hook]

## What's New
[Project updates and progress]

## Insights
[Learnings, observations, or tips]

## Resources
[Tools, links, or recommendations]

## What's Next
[Upcoming plans or milestones]

[Personal closing]
[Name/Signature]
```

## Tweet/X Post Creation

### Tweet Structure

1. **Hook** (First line):
   - Attention-grabbing opening
   - Clear value or insight
   - Match project's tweet style

2. **Body**:
   - Clear message or story
   - Project-specific context when relevant
   - Engaging and shareable

3. **Call-to-Action** (if needed):
   - Clear next step
   - Match project's CTA style

### Tweet Best Practices

- Keep it concise (under 280 characters, or thread for longer content)
- Use project's voice and tone
- Include relevant hashtags (discover from project)
- Make it shareable and engaging
- Add value or insight
- Use threads for longer content (discover project's thread style)

### Tweet Types

| Type | Description | Example Use |
|------|-------------|-------------|
| Updates | Project progress, launches, milestones | New feature announcement |
| Insights | Learnings, tips, observations | Industry observation |
| Questions | Engage audience, gather feedback | Poll or discussion starter |
| Resources | Links, tools, recommendations | Tool recommendation |
| Stories | Personal experiences, behind-the-scenes | Journey update |
| Promotional | Product updates, features | Launch announcement |

### Tweet Example Types

**Update Tweet:**

```
[Project update with context and value]
```

**Insight Tweet:**

```
[Learning or observation with project context]
```

**Question Tweet:**

```
[Engaging question related to project/industry]
```

**Resource Tweet:**

```
[Resource or tool recommendation with context]
```

## Content Lineup Generation

When users request a content lineup, generate a comprehensive content plan based on discovered project context.

### Step 1: Discover Current Project Context

**Thoroughly research the current project:**

1. **Read Project Documentation:**
   - Check `.agents/SYSTEM/ARCHITECTURE.md` for project overview
   - Review `.agents/SYSTEM/SUMMARY.md` for current status
   - Read `README.md` for project description and purpose
   - Check any project documentation files

2. **Identify Project Details:**
   - Project name and purpose
   - Target audience
   - Key features and capabilities
   - Current phase (development, launch, growth)
   - Recent updates or milestones
   - Upcoming plans or roadmap items

3. **Discover Brand Voice:**
   - Review existing content examples
   - Check for brand voice guidelines
   - Identify tone and style
   - Note terminology and messaging

4. **Review Existing Content:**
   - Check for previous newsletters or social posts
   - Identify content patterns and themes
   - Note what worked well
   - Understand content gaps

### Step 2: Generate Content Lineup

**Create a comprehensive content lineup document that includes:**

1. **Content Strategy Overview:**
   - Brief summary of project and audience
   - Content goals and themes
   - Platform focus (newsletter, Twitter/X, etc.)

2. **Newsletter Content Ideas:**
   - 4-6 newsletter topics with:
     - Subject line ideas
     - Content outline/structure
     - Key messages
     - Call-to-action suggestions

3. **Tweet/X Post Ideas:**
   - 10-15 tweet ideas organized by category:
     - Product updates
     - Educational/How-to
     - Tips & insights
     - Community engagement
     - Behind-the-scenes
   - Include hashtag suggestions (discover from project)

4. **Content Calendar:**
   - Weekly or monthly schedule
   - Mix of newsletter and tweet content
   - Themed weeks or months
   - Alignment with project milestones

5. **Content Themes:**
   - Monthly or quarterly themes
   - Topic clusters
   - Content series ideas

6. **Content Mix Guidelines:**
   - Recommended distribution (e.g., 40% educational, 30% updates)
   - Platform-specific guidelines
   - Frequency recommendations

7. **Key Messages:**
   - Core value propositions
   - Key differentiators
   - Consistent messaging points

### Step 3: Ensure Project-Specific Context

**Every content idea must:**

- Reference actual project features, updates, or milestones
- Use project-specific terminology
- Align with discovered brand voice
- Include relevant project context
- Be tailored to the project's target audience

**Never generate generic content lineups.** Every piece should be specific to the current project context.

## Content Creation Workflow

### For Newsletters

1. **Discover Context:**
   - Review project documentation
   - Check for recent updates or milestones
   - Identify key topics to cover
   - Review previous newsletters for style

2. **Plan Structure:**
   - Determine newsletter sections
   - Plan content for each section
   - Identify call-to-action

3. **Write Content:**
   - Use project's brand voice
   - Include project-specific context
   - Maintain personal and authentic tone
   - Add value in every section

4. **Review & Refine:**
   - Check voice consistency
   - Ensure clarity and engagement
   - Verify project-specific details
   - Confirm brand alignment

### For Tweets

1. **Discover Context:**
   - Review project documentation
   - Identify tweet topic or purpose
   - Check for relevant project updates
   - Review previous tweets for style

2. **Write Tweet:**
   - Use project's brand voice
   - Keep it concise and engaging
   - Include project-specific context when relevant
   - Add value or insight

3. **Review & Refine:**
   - Check voice consistency
   - Ensure clarity and engagement
   - Verify character count
   - Confirm brand alignment

## Content Checklist

### General Content

- [ ] Brand voice matches project guidelines
- [ ] Tone is consistent with existing content
- [ ] Project-specific context included
- [ ] Value provided in every piece
- [ ] Clear call-to-action (if needed)
- [ ] Authentic and personal voice maintained
- [ ] Content is engaging and shareable

### Content Lineup

- [ ] Discovered project context and purpose
- [ ] Identified key topics and themes
- [ ] Planned content mix (updates, insights, resources)
- [ ] Created content calendar
- [ ] Generated content ideas aligned with project
- [ ] Maintained consistent voice across all content
