# 스킬 품질 기준 상세

스킬 감사 시 사용하는 상세 품질 체크리스트.
각 항목은 PASS / WARN / FAIL로 평가한다.

## 1. Frontmatter 검증

### 필수 필드

| 필드 | 필수 | 규칙 |
|------|------|------|
| `name` | 필수 | kebab-case, 디렉토리명과 정확히 일치 |
| `description` | 필수 | 3인칭 서술, `Triggers:` 구문 포함 |
| `allowed-tools` | 선택 | Bash 권한 제한 필요 시 (프로젝트별 관례) |
| `license` | 선택 | 외부 출처 스킬에만 |

### YAML 구문 규칙

- `---` 구분자로 시작/종료
- 들여쓰기: 2칸 스페이스
- 멀티라인 값: `|` (리터럴) 또는 `>-` (접힘) 사용
- 특수문자 포함 시 따옴표 감싸기

### 평가 기준

| 등급 | 조건 |
|------|------|
| FAIL | `---` 누락, `name` 또는 `description` 없음 |
| WARN | name과 디렉토리명 불일치, YAML 파싱 경고 |
| PASS | 모든 필수 필드 존재, 구문 오류 없음 |

## 2. Description 품질

### 좋은 description의 조건

1. **3인칭 서술**: "This skill should be used when..." 또는 도구/기능 설명으로 시작
2. **구체적 트리거**: `Triggers:` 키워드 목록 필수
3. **범위 명시**: 다른 스킬과의 경계 명시 (선택적이지만 권장)
4. **한영 혼용**: 한국어 트리거 + 영어 트리거 모두 포함

### 좋은 예시

```yaml
description: |
  Claude Code hooks, plugins, aliases, MCP, and settings.json.
  Triggers: "how to create a hook", "add a plugin", "claude alias",
  "--chrome flag", "claude settings", "mcp.json", PreToolUse/PostToolUse/Stop
  hooks, plugin installation, ghost plugin issues, settings read-only.
```

- 첫 줄에 범위 요약
- Triggers에 구체적 문구
- 영어/기술 용어 혼합

### 나쁜 예시

```yaml
description: "Manages things related to the system configuration."
```

- 모호한 "things related to"
- 트리거 키워드 없음
- 어떤 시스템인지 특정 불가

### 평가 기준

| 등급 | 조건 |
|------|------|
| FAIL | Triggers 없음 또는 1인칭/2인칭 사용 |
| WARN | Triggers 부족 (1-4개) 또는 한국어/영어 한쪽만 |
| PASS | 3인칭 + Triggers 5개 이상 + 한영 혼용 |

## 3. 본문 내용 품질

### 문체 규칙

- **명령형/서술형 사용**: "검사한다", "확인한다", "수행한다"
- **2인칭 지양**: "you should", "~하세요" 대신 "~한다", "~해야 한다"
- 단, 사용자 대상 안내 섹션("빠른 참조", "사용법")에서는 2인칭 허용

### 구조 패턴

좋은 SKILL.md는 다음 흐름을 따른다:

1. **Purpose/범위** — 이 스킬이 무엇을 다루는지 (1-2문장)
2. **빠른 참조** — 가장 자주 쓰는 명령어/경로/설정 (테이블 형태)
3. **핵심 절차** — 주요 워크플로우 (단계별)
4. **자주 발생하는 문제** — 번호 매기기, 문제 → 해결 순서
5. **참조** — references/ 파일 링크

### 크기 가이드라인

| 구분 | 권장 범위 | 초과 시 조치 |
|------|----------|-------------|
| SKILL.md | 200-1200 단어 | 1500 초과 시 references/ 분리 검토 |
| references/ 개별 파일 | 200-3000 단어 | 5000 초과 시 분할 검토 |
| references/ 파일 수 | 1-7개 | 8개 이상 시 스킬 분할 검토 |

### 평가 기준

| 등급 | 조건 |
|------|------|
| FAIL | SKILL.md가 비어 있거나 frontmatter만 있음 |
| WARN | 1500단어 초과, 또는 references/ 없이 모든 내용을 SKILL.md에 기술 |
| PASS | 200-1200단어, 핵심 절차 포함, 적절한 구조 |

## 4. 프로그레시브 디스클로저

### 원칙

SKILL.md를 읽으면 "무엇을 어떻게 하는지" 즉시 파악 가능해야 한다.
상세한 설정값, 트러블슈팅 케이스, 히스토리 등은 references/에 위임한다.

### SKILL.md에 넣어야 할 것

- 스킬의 목적과 범위
- 핵심 명령어/절차 (복사해서 바로 실행 가능)
- 가장 흔한 3-5개 문제의 해결책
- references/ 파일 목록과 언제 참조할지 안내

### references/에 넣어야 할 것

- 상세 설정 가이드
- 전체 트러블슈팅 케이스
- 명령어 레퍼런스
- 히스토리/배경 설명
- 템플릿, 예시 코드

### 평가 기준

| 등급 | 조건 |
|------|------|
| FAIL | SKILL.md 20줄 이하 (너무 적음) 또는 references/ 없이 2000단어 초과 |
| WARN | references/ 없이 SKILL.md가 800단어 이상 |
| PASS | 핵심 절차가 SKILL.md에 있고, 상세 내용이 references/에 분리됨 |

## 5. 참조 유효성

### 파일 경로 확인

SKILL.md 내 `references/*.md` 링크가 실제 파일로 존재하는지 확인한다.
상대 경로 기준은 SKILL.md가 위치한 디렉토리이다.

### 코드베이스 참조 확인

SKILL.md에서 backtick으로 감싼 파일 경로가 현재 코드베이스에 존재하는지 검증한다:

- `modules/`, `scripts/`, `libraries/` 등 프로젝트 내부 경로
- `~/.config/`, `~/.claude/` 등 홈 디렉토리 경로
- `/nix/store/` 경로는 동적이므로 검증 생략

### 평가 기준

| 등급 | 조건 |
|------|------|
| FAIL | references/ 링크가 깨져 있음 |
| WARN | 1-2개 코드베이스 경로 미존재 (사소한 오타 가능성) |
| PASS | 모든 참조 파일/경로 유효 |

## 6. 라우팅 테이블 효과성

### 트리거 키워드 평가

- **충분한 수**: 최소 3개 이상의 구체적 키워드
- **다양한 언어**: 한국어 + 영어 혼합
- **구체성**: "설정" 같은 일반 단어 단독 사용 지양
- **실제 사용 패턴**: 사용자가 실제로 입력할 법한 문구

### CLAUDE.md 라우팅 항목 평가

- 스킬의 description Triggers와 CLAUDE.md 라우팅 키워드가 대응하는지
- 스킬명이 정확한지 (오타, 이전 이름 잔재 없는지)
- 같은 키워드가 여러 스킬에 등록되어 있지 않은지 (키워드 충돌)

### 평가 기준

| 등급 | 조건 |
|------|------|
| FAIL | 스킬이 CLAUDE.md 라우팅 테이블에 미등록 |
| WARN | 키워드 부족 (1-2개) 또는 한/영 한쪽만, 키워드 충돌 존재 |
| PASS | 3개 이상 키워드, 한영 혼용, CLAUDE.md와 description 대응 |

## 7. 스코프 분석 기준

### 분할 후보 (하나의 스킬이 너무 넓음)

다음 조건 중 2개 이상 해당 시 분할을 권장한다:

- SKILL.md + references/ 합계 5000단어 초과
- 두 개 이상의 독립적인 도구/서비스를 다룸
- description에 "For X details use Y" 등 다른 스킬로의 위임 문구가 있음
- 사용자가 A 주제로 트리거했을 때 B 주제의 불필요한 컨텍스트까지 로드됨

### 병합 후보 (두 스킬이 너무 겹침)

다음 조건 중 2개 이상 해당 시 병합을 권장한다:

- 트리거 키워드의 50% 이상이 중복
- 하나의 작업을 완수하려면 두 스킬을 번갈아 참조해야 함
- references/ 파일에 중복 내용 존재
- 두 스킬의 SKILL.md가 각각 300단어 미만 (너무 작음)

### 신규 스킬 후보

다음 영역에서 스킬 부재를 확인한다:

- 코드베이스의 주요 모듈/서비스 중 스킬이 없는 것
- CLAUDE.md에 반복적으로 기술되는 절차 (스킬로 추출 가능)
- 사용자가 자주 질문하지만 스킬이 없어 매번 탐색이 필요한 영역

### 제거 후보

다음 조건 해당 시 스킬 제거를 권장한다:

- 참조하는 서비스/도구가 코드베이스에서 완전히 제거됨
- git log 기반 확인 가능 시: 6개월 이상 내용 업데이트 없고 코드베이스와 심각하게 불일치
- 다른 스킬에 완전히 흡수되어 독립 존재 가치 없음
