# AGENTS.override.md Template

## Purpose

`AGENTS.override.md` supplements `AGENTS.md` with Codex-specific rules.
It contains both auto-generated content (rules, plugin CLAUDE.md) and user customizations.

## Marker-Based Sections

```markdown
# Codex CLI 보충 규칙

## 이 파일의 역할

AGENTS.md(= CLAUDE.md 심링크)의 프로젝트 규칙을 모두 따르되, 아래는 Codex 전용 보충이다.

<!-- AUTO-GENERATED BY syncing-codex-harness -->
(auto-generated content here — rules, plugin CLAUDE.md)
<!-- END AUTO-GENERATED BY syncing-codex-harness -->

## 사용자 커스텀

(user-specific rules — preserved across syncs)
```

## Auto-Generated Section Content

The auto-generated section may include:

### 1. Plugin Rules (from `{installPath}/rules/*.md`)
- Extract markdown body (strip YAML frontmatter)
- Prefix each rule with its filename as heading

### 2. Plugin CLAUDE.md
- When plugin provides a CLAUDE.md and it differs from project CLAUDE.md
- Include as a subsection

### 3. Codex-specific notes
- Skill invocation syntax: `$skill-name` (not `/skill-name`)
- Hooks/plugins not supported in Codex

## Preservation Logic

When `AGENTS.override.md` already exists:
1. Find `<!-- AUTO-GENERATED BY syncing-codex-harness -->` marker
2. Find `<!-- END AUTO-GENERATED BY syncing-codex-harness -->` marker
3. Replace content between markers only
4. Everything outside markers is preserved (user customizations)

When `AGENTS.override.md` doesn't exist:
- Create new file with auto-generated section + default user section template

## Automated Generation

The `sync.sh agents-override` subcommand automates this process:
```bash
sync.sh agents-override <project-root> --plugin-install-path=PATH:NAME
```

It handles frontmatter stripping, marker-based replacement, and template creation automatically.
When used via `sync.sh all`, this step is included in the pipeline.
