---
name: understanding-nix
description: |
  Nix fundamentals: flakes, derivations, substituters, devShell.
  Triggers: "nix flake update", "flake change detection", "slow build",
  "substituter", "derivation", "direnv", "devShell",
  "experimental features", "Nix 빌드 느림", "flake 인식 안 됨",
  "nixos/darwin 공통 nix 이슈".
---

# Nix 공통 이슈

NixOS와 nix-darwin 모두에 해당하는 Nix 공통 개념 및 이슈입니다.

## 목적과 범위

flake 평가, derivation 해석, substituter/빌드 성능, 공통 오류 복구 절차를 다룬다.

## 핵심 개념

### Flake 시스템

```bash
# flake.nix: 입력과 출력 정의
# flake.lock: 입력 버전 고정

# flake 업데이트
nix flake update

# 특정 입력만 업데이트
nix flake lock --update-input nixpkgs
```

### Experimental Features

```bash
# 필요한 기능들
experimental-features = nix-command flakes

# 설정 위치
~/.config/nix/nix.conf        # 사용자별
/etc/nix/nix.conf             # 시스템 전역
```

## 빠른 참조

### flake 변경이 인식되지 않음

```bash
# 원인 1: git에서 추적되지 않는 파일
# 해결: git add 필요
git add .
nrs

# 원인 2: 외부 flake input 업데이트 후 flake.lock 미갱신
nix flake update <input-name>
nrs
```

### 빌드 속도 최적화

| 방법 | 명령어 | 효과 |
|------|--------|------|
| 오프라인 빌드 | `nrs-offline` | 네트워크 요청 없음, 가장 빠름 |
| 병렬 다운로드 | `max-substitution-jobs = 128` | 다운로드 병렬화 |
| GitHub 토큰 | `access-tokens = github.com=...` | rate limit 해제 |

### 에러 디버깅

```bash
# 상세 빌드 로그
nix build --show-trace

# derivation 확인
nix derivation show .#darwinConfigurations.<host>.system
```

## 핵심 절차

1. 먼저 flake 상태(`git add`, `nix flake update`)를 정합화한다.
2. 빌드 속도 이슈는 substituter/오프라인 모드로 분리 진단한다.
3. 실패 시 `--show-trace`와 derivation 조회로 원인 모듈을 좁힌다.
4. 수정 후 `nrs` 또는 `nrs-offline`으로 재검증한다.

## 자주 발생하는 문제

1. **flake 인식 안 됨**: `git add` 필요 (untracked 무시)
2. **experimental features**: `nix-command flakes` 활성화 필요
3. **빌드 느림**: `--offline` 사용 또는 substituter 확인

## 레퍼런스

- 트러블슈팅: [references/troubleshooting.md](references/troubleshooting.md)
- 기능 목록: [references/features.md](references/features.md)
