---
name: conductor-status
description: Display project status, active tracks, and next actions
metadata:
  argument-hint: "[track-id] [--detailed]"
---

# Conductor Status

Display the current status of the Conductor project, including overall progress, active tracks, and next actions.

## Use this skill when

- Working on conductor status tasks or workflows
- Needing guidance, best practices, or checklists for conductor status

## Do not use this skill when

- The task is unrelated to conductor status
- You need a different domain or tool outside this scope

## Instructions

- Clarify goals, constraints, and required inputs.
- Apply relevant best practices and validate outcomes.
- Provide actionable steps and verification.
- If detailed examples are required, open `resources/implementation-playbook.md`.

## Pre-flight Checks

1. Verify Conductor is initialized:
   - Check `conductor/product.md` exists
   - Check `conductor/tracks.md` exists
   - If missing: Display error and suggest running `/conductor:setup` first

2. Check for any tracks:
   - Read `conductor/tracks.md`
   - If no tracks registered: Display setup complete message with suggestion to create first track

## Data Collection

### 1. Project Information

Read `conductor/product.md` and extract:

- Project name
- Project description

### 2. Tracks Overview

Read `conductor/tracks.md` and parse:

- Total tracks count
- Completed tracks (marked `[x]`)
- In-progress tracks (marked `[~]`)
- Pending tracks (marked `[ ]`)

### 3. Detailed Track Analysis

For each track in `conductor/tracks/`:

Read `conductor/tracks/{trackId}/plan.md`:

- Count total tasks (lines matching `- [x]`, `- [~]`, `- [ ]` with Task prefix)
- Count completed tasks (`[x]`)
- Count in-progress tasks (`[~]`)
- Count pending tasks (`[ ]`)
- Identify current phase (first phase with incomplete tasks)
- Identify next pending task

Read `conductor/tracks/{trackId}/metadata.json`:

- Track type (feature, bug, chore, refactor)
- Created date
- Last updated date
- Status

Read `conductor/tracks/{trackId}/spec.md`:

- Check for any noted blockers or dependencies

### 4. Blocker Detection

Scan for potential blockers:

- Tasks marked with `BLOCKED:` prefix
- Dependencies on incomplete tracks
- Failed verification tasks

## Output Format

### Full Project Status (no argument)

```
================================================================================
                        PROJECT STATUS: {Project Name}
================================================================================
Last Updated: {current timestamp}

--------------------------------------------------------------------------------
                              OVERALL PROGRESS
--------------------------------------------------------------------------------

Tracks:     {completed}/{total} completed ({percentage}%)
Tasks:      {completed}/{total} completed ({percentage}%)

Progress:   [##########..........] {percentage}%

--------------------------------------------------------------------------------
                              TRACK SUMMARY
--------------------------------------------------------------------------------

| Status | Track ID          | Type    | Tasks      | Last Updated |
|--------|-------------------|---------|------------|--------------|
| [x]    | auth_20250110     | feature | 12/12 (100%)| 2025-01-12  |
| [~]    | dashboard_20250112| feature | 7/15 (47%) | 2025-01-15  |
| [ ]    | nav-fix_20250114  | bug     | 0/4 (0%)   | 2025-01-14  |

--------------------------------------------------------------------------------
                              CURRENT FOCUS
--------------------------------------------------------------------------------

Active Track:  dashboard_20250112 - Dashboard Feature
Current Phase: Phase 2: Core Components
Current Task:  [~] Task 2.3: Implement chart rendering

Progress in Phase:
  - [x] Task 2.1: Create dashboard layout
  - [x] Task 2.2: Add data fetching hooks
  - [~] Task 2.3: Implement chart rendering
  - [ ] Task 2.4: Add filter controls

--------------------------------------------------------------------------------
                              NEXT ACTIONS
--------------------------------------------------------------------------------

1. Complete: Task 2.3 - Implement chart rendering (dashboard_20250112)
2. Then: Task 2.4 - Add filter controls (dashboard_20250112)
3. After Phase 2: Phase verification checkpoint

--------------------------------------------------------------------------------
                               BLOCKERS
--------------------------------------------------------------------------------

{If blockers found:}
! BLOCKED: Task 3.1 in dashboard_20250112 depends on api_20250111 (incomplete)

{If no blockers:}
No blockers identified.

================================================================================
Commands: /conductor:implement {trackId} | /conductor:new-track | /conductor:revert
================================================================================
```

### Single Track Status (with track-id argument)

```
================================================================================
                    TRACK STATUS: {Track Title}
================================================================================
Track ID:    {trackId}
Type:        {feature|bug|chore|refactor}
Status:      {Pending|In Progress|Complete}
Created:     {date}
Updated:     {date}

--------------------------------------------------------------------------------
                              SPECIFICATION
--------------------------------------------------------------------------------

Summary: {brief summary from spec.md}

Acceptance Criteria:
  - [x] {Criterion 1}
  - [ ] {Criterion 2}
  - [ ] {Criterion 3}

--------------------------------------------------------------------------------
                              IMPLEMENTATION
--------------------------------------------------------------------------------

Overall:    {completed}/{total} tasks ({percentage}%)
Progress:   [##########..........] {percentage}%

## Phase 1: {Phase Name} [COMPLETE]
  - [x] Task 1.1: {description}
  - [x] Task 1.2: {description}
  - [x] Verification: {description}

## Phase 2: {Phase Name} [IN PROGRESS]
  - [x] Task 2.1: {description}
  - [~] Task 2.2: {description}  <-- CURRENT
  - [ ] Task 2.3: {description}
  - [ ] Verification: {description}

## Phase 3: {Phase Name} [PENDING]
  - [ ] Task 3.1: {description}
  - [ ] Task 3.2: {description}
  - [ ] Verification: {description}

--------------------------------------------------------------------------------
                              GIT HISTORY
--------------------------------------------------------------------------------

Related Commits:
  abc1234 - feat: add login form ({trackId})
  def5678 - feat: add password validation ({trackId})
  ghi9012 - chore: mark task 1.2 complete ({trackId})

--------------------------------------------------------------------------------
                              NEXT STEPS
--------------------------------------------------------------------------------

1. Current: Task 2.2 - {description}
2. Next: Task 2.3 - {description}
3. Phase 2 verification pending

================================================================================
Commands: /conductor:implement {trackId} | /conductor:revert {trackId}
================================================================================
```

## Status Markers Legend

Display at bottom if helpful:

```
Legend:
  [x] = Complete
  [~] = In Progress
  [ ] = Pending
  [!] = Blocked
```

## Error States

### No Tracks Found

```
================================================================================
                        PROJECT STATUS: {Project Name}
================================================================================

Conductor is set up but no tracks have been created yet.

To get started:
  /conductor:new-track "your feature description"

================================================================================
```

### Conductor Not Initialized

```
ERROR: Conductor not initialized

Could not find conductor/product.md

Run /conductor:setup to initialize Conductor for this project.
```

### Track Not Found (with argument)

```
ERROR: Track not found: {argument}

Available tracks:
  - auth_20250115
  - dashboard_20250112
  - nav-fix_20250114

Usage: /conductor:status [track-id]
```

## Calculation Logic

### Task Counting

```
For each plan.md:
  - Complete: count lines matching /^- \[x\] Task/
  - In Progress: count lines matching /^- \[~\] Task/
  - Pending: count lines matching /^- \[ \] Task/
  - Total: Complete + In Progress + Pending
```

### Phase Detection

```
Current phase = first phase header followed by any incomplete task ([ ] or [~])
```

### Progress Bar

```
filled = floor((completed / total) * 20)
empty = 20 - filled
bar = "[" + "#".repeat(filled) + ".".repeat(empty) + "]"
```

## Quick Mode

If invoked with `--quick` or `-q`:

```
{Project Name}: {completed}/{total} tasks ({percentage}%)
Active: {trackId} - Task {X.Y}
```

## JSON Output

If invoked with `--json`:

```json
{
  "project": "{name}",
  "timestamp": "ISO_TIMESTAMP",
  "tracks": {
    "total": N,
    "completed": X,
    "in_progress": Y,
    "pending": Z
  },
  "tasks": {
    "total": M,
    "completed": A,
    "in_progress": B,
    "pending": C
  },
  "current": {
    "track": "{trackId}",
    "phase": N,
    "task": "{X.Y}"
  },
  "blockers": []
}
```
