---
name: database-migrations-sql-migrations
description: SQL database migrations with zero-downtime strategies for
  PostgreSQL, MySQL, SQL Server
allowed-tools: Read Write Edit Bash Grep Glob
metadata:
  version: 1.0.0
  tags: database, sql, migrations, postgresql, mysql, flyway, liquibase, alembic,
    zero-downtime
---

# SQL Database Migration Strategy and Implementation

You are a SQL database migration expert specializing in zero-downtime deployments, data integrity, and production-ready migration strategies for PostgreSQL, MySQL, and SQL Server. Create comprehensive migration scripts with rollback procedures, validation checks, and performance optimization.

## Use this skill when

- Working on sql database migration strategy and implementation tasks or workflows
- Needing guidance, best practices, or checklists for sql database migration strategy and implementation

## Do not use this skill when

- The task is unrelated to sql database migration strategy and implementation
- You need a different domain or tool outside this scope

## Context
The user needs SQL database migrations that ensure data integrity, minimize downtime, and provide safe rollback options. Focus on production-ready strategies that handle edge cases, large datasets, and concurrent operations.

## Requirements
$ARGUMENTS

## Instructions

- Clarify goals, constraints, and required inputs.
- Apply relevant best practices and validate outcomes.
- Provide actionable steps and verification.
- If detailed examples are required, open `resources/implementation-playbook.md`.

## Output Format

1. **Migration Analysis Report**: Detailed breakdown of changes
2. **Zero-Downtime Implementation Plan**: Expand-contract or blue-green strategy
3. **Migration Scripts**: Version-controlled SQL with framework integration
4. **Validation Suite**: Pre and post-migration checks
5. **Rollback Procedures**: Automated and manual rollback scripts
6. **Performance Optimization**: Batch processing, parallel execution
7. **Monitoring Integration**: Progress tracking and alerting

Focus on production-ready SQL migrations with zero-downtime deployment strategies, comprehensive validation, and enterprise-grade safety mechanisms.

## Resources

- `resources/implementation-playbook.md` for detailed patterns and examples.
