---
name: seo-fundamentals
description: >
  Core principles of SEO including E-E-A-T, Core Web Vitals, technical foundations,
  content quality, and how modern search engines evaluate pages. This skill explains
  *why* SEO works, not how to execute specific optimizations.
allowed-tools: Read, Glob, Grep
---

---

# SEO Fundamentals

> **Foundational principles for sustainable search visibility.**
> This skill explains _how search engines evaluate quality_, not tactical shortcuts.

---

## 1. E-E-A-T (Quality Evaluation Framework)

E-E-A-T is **not a direct ranking factor**.
It is a framework used by search engines to **evaluate content quality**, especially for sensitive or high-impact topics.

| Dimension             | What It Represents                 | Common Signals                                      |
| --------------------- | ---------------------------------- | --------------------------------------------------- |
| **Experience**        | First-hand, real-world involvement | Original examples, lived experience, demonstrations |
| **Expertise**         | Subject-matter competence          | Credentials, depth, accuracy                        |
| **Authoritativeness** | Recognition by others              | Mentions, citations, links                          |
| **Trustworthiness**   | Reliability and safety             | HTTPS, transparency, accuracy                       |

> Pages competing in the same space are often differentiated by **trust and experience**, not keywords.

---

## 2. Core Web Vitals (Page Experience Signals)

Core Web Vitals measure **how users experience a page**, not whether it deserves to rank.

| Metric  | Target  | What It Reflects    |
| ------- | ------- | ------------------- |
| **LCP** | < 2.5s  | Loading performance |
| **INP** | < 200ms | Interactivity       |
| **CLS** | < 0.1   | Visual stability    |

**Important context:**

- CWV rarely override poor content
- They matter most when content quality is comparable
- Failing CWV can _hold back_ otherwise good pages

---

## 3. Technical SEO Principles

Technical SEO ensures pages are **accessible, understandable, and stable**.

### Crawl & Index Control

| Element           | Purpose                |
| ----------------- | ---------------------- |
| XML sitemaps      | Help discovery         |
| robots.txt        | Control crawl access   |
| Canonical tags    | Consolidate duplicates |
| HTTP status codes | Communicate page state |
| HTTPS             | Security and trust     |

### Performance & Accessibility

| Factor                 | Why It Matters                |
| ---------------------- | ----------------------------- |
| Page speed             | User satisfaction             |
| Mobile-friendly design | Mobile-first indexing         |
| Clean URLs             | Crawl clarity                 |
| Semantic HTML          | Accessibility & understanding |

---

## 4. Content SEO Principles

### Page-Level Elements

| Element          | Principle                    |
| ---------------- | ---------------------------- |
| Title tag        | Clear topic + intent         |
| Meta description | Click relevance, not ranking |
| H1               | Page’s primary subject       |
| Headings         | Logical structure            |
| Alt text         | Accessibility and context    |

### Content Quality Signals

| Dimension   | What Search Engines Look For |
| ----------- | ---------------------------- |
| Depth       | Fully answers the query      |
| Originality | Adds unique value            |
| Accuracy    | Factually correct            |
| Clarity     | Easy to understand           |
| Usefulness  | Satisfies intent             |

---

## 5. Structured Data (Schema)

Structured data helps search engines **understand meaning**, not boost rankings directly.

| Type           | Purpose                |
| -------------- | ---------------------- |
| Article        | Content classification |
| Organization   | Entity identity        |
| Person         | Author information     |
| FAQPage        | Q&A clarity            |
| Product        | Commerce details       |
| Review         | Ratings context        |
| BreadcrumbList | Site structure         |

> Schema enables eligibility for rich results but does not guarantee them.

---

## 6. AI-Assisted Content Principles

Search engines evaluate **output quality**, not authorship method.

### Effective Use

- AI as a drafting or research assistant
- Human review for accuracy and clarity
- Original insights and synthesis
- Clear accountability

### Risky Use

- Publishing unedited AI output
- Factual errors or hallucinations
- Thin or duplicated content
- Keyword-driven text with no value

---

## 7. Relative Importance of SEO Factors

There is **no fixed ranking factor order**.
However, when competing pages are similar, importance tends to follow this pattern:

| Relative Weight | Factor                      |
| --------------- | --------------------------- |
| Highest         | Content relevance & quality |
| High            | Authority & trust signals   |
| Medium          | Page experience (CWV, UX)   |
| Medium          | Mobile optimization         |
| Baseline        | Technical accessibility     |

> Technical SEO enables ranking; content quality earns it.

---

## 8. Measurement & Evaluation

SEO fundamentals should be validated using **multiple signals**, not single metrics.

| Area        | What to Observe            |
| ----------- | -------------------------- |
| Visibility  | Indexed pages, impressions |
| Engagement  | Click-through, dwell time  |
| Performance | CWV field data             |
| Coverage    | Indexing status            |
| Authority   | Mentions and links         |

---

> **Key Principle:**
> Sustainable SEO is built on _useful content_, _technical clarity_, and _trust over time_.
> There are no permanent shortcuts.
