# Stitch UI Design Skill

Expert guidance for creating effective prompts in Google Stitch, the AI-powered UI design tool.

## Overview

This skill provides comprehensive guidance for crafting precise, actionable prompts that generate high-quality UI designs in Google Stitch. It covers prompt structure, specificity techniques, iteration strategies, and design-to-code workflows.

## What's Included

### SKILL.md
Core prompting principles and techniques:
- Specificity and detail requirements
- Visual style definition
- Multi-screen flow structuring
- Platform and responsive specifications
- Functional requirements
- Prompt templates
- Iteration strategies
- Common use cases
- Anti-patterns to avoid

### References

#### prompt-examples.md
Comprehensive library of effective Stitch prompts organized by category:
- Landing pages
- Mobile apps
- Dashboards
- E-commerce
- Forms & authentication
- Content platforms
- SaaS applications

Each example includes detailed component breakdowns, style specifications, and platform requirements.

#### advanced-techniques.md
Advanced strategies for production-ready designs:
- Image-to-UI workflows
- Design system integration
- Responsive design strategies
- Accessibility considerations
- Performance optimization
- Component reusability
- Atomic design methodology
- Export and handoff best practices

## When to Use This Skill

Use this skill when:
- Creating UI designs in Google Stitch
- Generating mobile or web app interfaces
- Crafting effective Stitch prompts
- Converting sketches or wireframes to digital UI
- Building design systems
- Creating responsive layouts
- Ensuring accessibility compliance
- Optimizing design-to-code workflows

## Key Principles

1. **Be Specific** - Generic prompts yield generic results
2. **Define Visual Style** - Always include colors, aesthetics, and design direction
3. **Structure Clearly** - List components and sections explicitly
4. **Specify Platform** - Indicate mobile, tablet, desktop, or responsive
5. **Include Functionality** - Describe interactions, states, and user flows
6. **Iterate Incrementally** - Make focused changes rather than complete redesigns

## Quick Start

### Basic Prompt Template

```
[Screen/Component Type] for [User/Context]

Key Features:
- [Feature 1 with specific details]
- [Feature 2 with specific details]
- [Feature 3 with specific details]

Visual Style:
- [Color scheme]
- [Design aesthetic]
- [Layout approach]

Platform: [Mobile/Web/Responsive]
```

### Example Usage

```
Dashboard for SaaS analytics platform

Key Features:
- Top metrics cards showing MRR, active users, churn rate
- Line chart for revenue trends (last 30 days)
- Recent activity feed with user actions
- Quick action buttons for reports and exports

Visual Style:
- Dark mode with blue/purple gradient accents
- Modern glassmorphic cards with subtle shadows
- Clean data visualization with accessible colors

Platform: Responsive web (desktop-first)
```

## Best Practices

### Do's ✅
- Provide specific component details
- Define clear visual direction
- Specify responsive behavior
- Include interaction states
- Use design terminology
- Reference existing designs when helpful
- Iterate with annotations
- Consider accessibility from the start

### Don'ts ❌
- Use vague descriptions ("nice website")
- Omit visual style guidance
- Forget platform specifications
- Ignore responsive requirements
- Skip accessibility considerations
- Make complete redesigns instead of incremental changes

## Integration with Development

### Stitch → Figma → Code
1. Generate UI in Stitch with detailed prompts
2. Export to Figma for design system integration
3. Hand off to developers with design specs
4. Implement with production-ready code

### Stitch → HTML → Framework
1. Generate and refine UI in Stitch
2. Export HTML/CSS code
3. Convert to React/Vue/Svelte components
4. Integrate into application codebase

## Resources

- **SKILL.md** - Core prompting guide
- **prompt-examples.md** - 30+ detailed prompt examples
- **advanced-techniques.md** - Production-ready design strategies

## Tips for Success

1. Start with clear requirements and context
2. Use the prompt template for consistency
3. Reference examples for similar use cases
4. Iterate incrementally with annotations
5. Generate variants to explore options
6. Always specify visual style and platform
7. Consider accessibility in every prompt
8. Refine exports before production use

## About Google Stitch

Google Stitch is an experimental AI UI generator powered by Gemini 2.5 Flash that transforms text prompts and visual references into functional UI designs. It supports text-to-UI generation, image-to-UI conversion, multi-screen flows, and exports to HTML/CSS, Figma, and code.

---

**Note:** This skill is designed to help you create effective prompts for Stitch. The quality of your output depends on the specificity and clarity of your prompts. Use the templates and examples as starting points, then customize for your unique requirements.
