# Stitch Prompt Examples Library

Comprehensive collection of effective Stitch prompts organized by use case and complexity level.

## Table of Contents

1. [Landing Pages](#landing-pages)
2. [Mobile Apps](#mobile-apps)
3. [Dashboards](#dashboards)
4. [E-commerce](#e-commerce)
5. [Forms & Authentication](#forms--authentication)
6. [Content Platforms](#content-platforms)
7. [SaaS Applications](#saas-applications)

---

## Landing Pages

### Startup Landing Page

```
Landing page for AI writing assistant startup

Hero Section:
- Bold headline: "Write Better, Faster with AI"
- Subheadline explaining value proposition
- Primary CTA button "Start Free Trial"
- Secondary CTA "Watch Demo"
- Hero illustration showing product interface

Features Section:
- 3-column grid with icons
- Feature 1: AI-powered suggestions
- Feature 2: Multi-language support
- Feature 3: Team collaboration

Social Proof:
- Customer logos (6 companies)
- Testimonial cards with photos and quotes

Pricing:
- 3-tier pricing table (Free, Pro, Enterprise)
- Feature comparison
- Annual/Monthly toggle

Style: Modern, tech-forward, trustworthy
Colors: Deep purple primary, cyan accents, white background
Typography: Sans-serif, clean and readable
Platform: Responsive web
```

### Service Business Landing

```
Landing page for boutique yoga studio

Above Fold:
- Full-width hero image of studio space
- Centered headline: "Find Your Balance"
- Class schedule CTA button
- Location and hours overlay

Class Offerings:
- Card grid (2x3) with class types
- Each card: class name, duration, difficulty level, instructor photo
- Hover effect reveals class description

Instructor Profiles:
- Horizontal scrolling carousel
- Circular photos with names and specialties

Testimonials:
- Large quote format with student photos
- 5-star ratings

Call-to-Action:
- "Book Your First Class Free" banner
- Contact form with name, email, phone

Style: Calm, organic, welcoming
Colors: Sage green, warm beige, soft white
Typography: Serif headings, sans-serif body
Platform: Responsive web with mobile-first approach
```

---

## Mobile Apps

### Fitness Tracking App

```
Fitness tracking app - Home screen (iOS)

Top Section:
- Greeting with user name and current date
- Daily goal progress ring (calories, steps, active minutes)
- Motivational message based on progress

Quick Stats Cards:
- Today's steps with trend arrow
- Active calories burned
- Distance covered
- Active time

Recent Workouts:
- List of last 3 workouts with type, duration, calories
- Thumbnail icons for workout type
- Swipe actions for details/delete

Bottom Section:
- "Start Workout" prominent button
- Quick access to workout types (Run, Cycle, Strength, Yoga)

Bottom Navigation:
- Home (active), Workouts, Progress, Profile

Style: Energetic, motivating, data-focused
Colors: Vibrant orange primary, dark mode background, neon accents
Typography: Bold headings, clear metrics
Platform: iOS mobile (375x812px)
```

### Food Delivery App

```
Restaurant detail screen for food delivery app

Header:
- Restaurant cover photo
- Back button and favorite icon
- Restaurant name, rating (4.5 stars), delivery time (25-35 min)
- Cuisine tags (Italian, Pizza, Pasta)

Info Bar:
- Delivery fee, minimum order, distance
- Promo badge if applicable

Menu Categories:
- Sticky horizontal scroll tabs (Popular, Pizza, Pasta, Salads, Drinks)

Menu Items:
- Card layout with food photo, name, description, price
- Add button with quantity selector
- Dietary icons (vegetarian, spicy, etc.)

Floating Cart:
- Bottom sheet showing cart summary
- Item count and total price
- "View Cart" button

Style: Appetite-appealing, easy to scan, vibrant
Colors: Red primary (hunger-inducing), white background, food photography
Typography: Friendly sans-serif
Platform: Android mobile (360x800px)
```

---

## Dashboards

### Analytics Dashboard

```
Web analytics dashboard for marketing team

Top Bar:
- Date range selector (last 7 days, 30 days, custom)
- Export button
- Notification bell
- User profile dropdown

Key Metrics Row:
- 4 metric cards in a row
- Card 1: Total visitors (with % change)
- Card 2: Conversion rate (with trend sparkline)
- Card 3: Bounce rate (with comparison to previous period)
- Card 4: Average session duration

Main Chart:
- Line chart showing traffic over time
- Multiple lines for different sources (Organic, Paid, Social, Direct)
- Interactive legend to toggle lines
- Hover tooltips with exact values

Secondary Panels:
- Left: Top pages table (page, views, avg time, bounce rate)
- Right: Traffic sources pie chart with percentages

Bottom Section:
- Recent conversions table with user, source, value, timestamp

Style: Clean, data-focused, professional
Colors: Navy blue sidebar, white main area, colorful chart lines
Typography: Monospace for numbers, sans-serif for labels
Platform: Desktop web (1440px+)
```

### Project Management Dashboard

```
Project management dashboard - Team view

Sidebar:
- Workspace selector dropdown
- Navigation: Dashboard, Projects, Tasks, Team, Reports
- Create new project button

Header:
- Project name and status badge
- Team member avatars (max 5, then +N)
- Search bar
- View options (Board, List, Calendar)

Kanban Board:
- 4 columns: To Do, In Progress, Review, Done
- Drag-and-drop cards
- Each card shows: title, assignee avatar, due date, priority label, comment count
- Add card button at bottom of each column

Right Panel:
- Task details when card is selected
- Description, attachments, comments, activity log

Quick Stats:
- Progress bar showing completion percentage
- Tasks by status mini chart
- Upcoming deadlines list

Style: Modern, organized, collaborative
Colors: Purple primary, light gray background, status color coding
Typography: Clear sans-serif, readable at all sizes
Platform: Desktop web (1280px+)
```

---

## E-commerce

### Product Detail Page

```
Product detail page for fashion e-commerce

Image Gallery:
- Main product image (large, zoomable)
- Thumbnail strip below (5-6 images)
- 360° view option
- Video thumbnail if available

Product Info:
- Brand name
- Product title
- Star rating (4.8) with review count (234 reviews)
- Price with original price struck through if on sale
- Sale badge if applicable

Options:
- Size selector (XS, S, M, L, XL) with availability indicators
- Color swatches with product image preview on hover
- Quantity selector

Actions:
- Add to Cart button (prominent)
- Add to Wishlist button (outline)
- Size guide link
- Shipping calculator

Product Details:
- Tabbed interface (Description, Specifications, Reviews, Shipping)
- Expandable sections on mobile

Recommendations:
- "You May Also Like" carousel
- "Complete the Look" suggestions

Style: Clean, product-focused, trustworthy
Colors: Black and white with brand accent color (burgundy)
Typography: Elegant serif for headings, sans-serif for body
Platform: Responsive web
```

### Shopping Cart

```
Shopping cart page with checkout flow

Cart Items:
- List of products with thumbnail, name, size/color, price
- Quantity adjuster (+/- buttons)
- Remove item link
- Save for later option

Order Summary:
- Sticky sidebar on desktop, bottom sheet on mobile
- Subtotal
- Shipping (calculated or "Free over $50")
- Tax (estimated)
- Discount code input field
- Total (prominent)
- Checkout button (large, primary color)

Trust Signals:
- Secure checkout badge
- Free returns policy
- Customer service contact

Recommendations:
- "Frequently Bought Together" section
- Promotional banner for free shipping threshold

Empty State:
- Illustration
- "Your cart is empty" message
- "Continue Shopping" button
- Recently viewed items

Style: Clean, conversion-focused, reassuring
Colors: Green for checkout CTA, neutral grays, trust badges
Typography: Clear pricing, readable product names
Platform: Responsive web
```

---

## Forms & Authentication

### Multi-Step Signup Form

```
B2B SaaS signup flow - 3 steps

Progress Indicator:
- Step 1: Account (active)
- Step 2: Company
- Step 3: Team

Step 1 - Account Details:
- Email input with validation
- Password input with strength indicator
- Confirm password
- Terms and conditions checkbox
- "Continue" button
- "Already have an account? Sign in" link

Step 2 - Company Information:
- Company name
- Industry dropdown
- Company size radio buttons (1-10, 11-50, 51-200, 201+)
- Role/Title input
- "Back" and "Continue" buttons

Step 3 - Invite Team:
- Email input fields (dynamic, add more)
- Role selector for each invite
- "Skip for now" option
- "Finish Setup" button

Success State:
- Checkmark animation
- "Welcome to [Product]!" message
- "Go to Dashboard" button

Style: Minimal, focused, low-friction
Colors: Blue primary, white background, green success states
Typography: Clear labels, helpful microcopy
Platform: Responsive web, mobile-optimized
```

### Login Page

```
Login page for enterprise software

Left Panel (Desktop):
- Brand logo
- Hero image or illustration
- Value proposition headline
- Key benefits (3 bullet points)

Right Panel (Form):
- "Welcome back" heading
- Email input field
- Password input field with show/hide toggle
- "Remember me" checkbox
- "Forgot password?" link
- "Sign In" button (full width)
- Divider with "OR"
- SSO options (Google, Microsoft, Okta) as buttons with logos
- "Don't have an account? Sign up" link at bottom

Security Indicators:
- SSL badge
- "Your data is secure" message

Style: Professional, trustworthy, enterprise-grade
Colors: Corporate blue, white, subtle grays
Typography: Professional sans-serif
Platform: Responsive (left panel hidden on mobile)
```

---

## Content Platforms

### Blog Post Layout

```
Blog article page for tech publication

Header:
- Site navigation (logo, categories, search, subscribe)

Article Header:
- Category tag
- Article title (large, bold)
- Subtitle/excerpt
- Author info (photo, name, bio link, publish date)
- Social share buttons
- Reading time estimate

Article Body:
- Readable column width (max 680px)
- Paragraph text with proper line height
- H2 and H3 subheadings
- Pull quotes (styled distinctly)
- Inline images with captions
- Code blocks with syntax highlighting
- Embedded videos
- Table of contents (sticky sidebar on desktop)

Article Footer:
- Tags
- Share buttons
- Author card (expanded)
- Related articles (3 cards)
- Comments section

Sidebar (Desktop):
- Newsletter signup
- Popular posts
- Ad placement

Style: Editorial, readable, content-first
Colors: Black text on white, accent color for links
Typography: Serif for body text, sans-serif for UI
Platform: Responsive web
```

### Video Platform Interface

```
Video streaming platform - Watch page

Video Player:
- Full-width video player with controls
- Quality selector, playback speed, captions, fullscreen
- Progress bar with thumbnail preview on hover

Video Info:
- Video title
- View count and upload date
- Like/Dislike buttons
- Share button
- Save to playlist button

Channel Info:
- Channel avatar and name
- Subscriber count
- Subscribe button (prominent if not subscribed)

Description:
- Expandable description text
- Show more/less toggle
- Hashtags and links

Comments Section:
- Sort options (Top, Newest)
- Comment input with user avatar
- Comment cards with avatar, name, timestamp, text
- Like/Reply buttons
- Nested replies (indented)

Sidebar:
- Up next autoplay preview
- Recommended videos list (thumbnail, title, channel, views)

Style: Dark mode, video-focused, minimal distractions
Colors: Dark gray background, white text, red accent for CTAs
Typography: Sans-serif, readable at distance
Platform: Responsive web
```

---

## SaaS Applications

### Email Client Interface

```
Email client - Inbox view

Left Sidebar:
- Compose button (prominent)
- Folder list (Inbox, Sent, Drafts, Spam, Trash)
- Labels/Tags with color coding
- Storage usage indicator

Email List (Center):
- Search bar with filters
- Sort and view options
- Email rows showing:
  - Sender avatar/initial
  - Sender name (bold if unread)
  - Subject line
  - Preview text (truncated)
  - Timestamp
  - Attachment icon if present
  - Star/flag icons
- Checkbox for bulk actions
- Pagination or infinite scroll

Email Detail (Right):
- Email header (from, to, cc, timestamp)
- Subject line
- Email body with formatting preserved
- Attachments section
- Action buttons (Reply, Reply All, Forward, Archive, Delete)
- Previous emails in thread (collapsed)

Top Bar:
- Refresh button
- Settings icon
- User profile dropdown

Style: Clean, productivity-focused, organized
Colors: Blue accents, white background, gray dividers
Typography: Sans-serif, scannable
Platform: Desktop web (1280px+)
```

### CRM Contact Detail

```
CRM contact detail page

Header:
- Contact name and company
- Contact photo/avatar
- Status badge (Lead, Customer, Inactive)
- Quick actions (Email, Call, Schedule Meeting, Edit)

Info Tabs:
- Overview (active), Activity, Deals, Notes, Files

Overview Tab:
- Contact information card (email, phone, address, social links)
- Company information card
- Tags and custom fields
- Assigned to (team member)

Activity Timeline:
- Chronological list of interactions
- Icons for type (email, call, meeting, note)
- Timestamp and description
- Filter by activity type

Deals Section:
- Active deals table (deal name, value, stage, close date)
- Won/Lost deals summary

Notes Section:
- Add note input with rich text editor
- Note cards with author, timestamp, content
- Pin important notes

Right Sidebar:
- Next scheduled activity
- Recent emails
- Related contacts
- Deal pipeline stage

Style: Professional, data-rich, organized
Colors: Navy blue, white, status color coding
Typography: Clear hierarchy, readable data
Platform: Desktop web (1440px+)
```

---

## Tips for Using These Examples

1. **Customize for your needs** - Replace placeholder content with your specific requirements
2. **Combine elements** - Mix and match components from different examples
3. **Adjust complexity** - Simplify or expand based on your project scope
4. **Specify your brand** - Add your color palette, fonts, and visual style
5. **Consider platform** - Adapt layouts for your target device (mobile/desktop)
6. **Add context** - Include user personas or use cases for better results
7. **Iterate** - Start with a basic prompt, then refine with annotations

Remember: These are starting points. Stitch works best when you provide specific details relevant to your unique project.
