# Requesting Code Review

## When to Request

- After each task in subagent-driven development
- After major feature completion
- Before merge to main
- When stuck and need fresh perspective
- After fixing complex bugs

## Review Process

1. **Prepare context:**
   - What was implemented
   - Plan or requirements
   - Git SHAs (BASE_SHA, HEAD_SHA)
   - Description of changes

2. **Request review:**
   - Use systematic review process
   - Provide full context
   - Include relevant files

3. **Act on feedback:**
   - Fix Critical issues immediately
   - Address Important before proceeding
   - Note Minor for later consideration

## Review Checklist

- [ ] Functionality works as intended
- [ ] Edge cases handled
- [ ] Error handling appropriate
- [ ] Code follows project conventions
- [ ] Tests are present and passing
- [ ] No obvious bugs or logic errors
- [ ] Security considerations addressed
- [ ] Performance implications considered

## Integration with Workflows

- **Subagent-Driven:** Review after EACH task
- **Pull Requests:** Request review before merge
- **Feature Completion:** Review before marking done
