# Tool Design

Tool consolidation, description engineering, and tool design best practices.

## Tool Description Engineering

### Four-Question Framework
1. **What** - What does the tool do?
2. **When** - When should it be used?
3. **Inputs** - What parameters does it accept?
4. **Returns** - What does it return?

### Best Practices
- Clear, concise descriptions
- Specific use cases
- Example inputs/outputs
- Error conditions

## Tool Consolidation

### Benefits
- Fewer tool definitions
- Lower token usage
- Simpler agent reasoning
- Better tool selection

### Patterns
- Combine related tools
- Use parameters for variation
- Generic tools with options
- Tool hierarchies

## Tool Selection

### Factors
- Task requirements
- Available tools
- Tool capabilities
- Performance considerations

### Optimization
- Clear descriptions aid selection
- Group related tools
- Prioritize common tools
- Monitor tool usage

## Best Practices

1. Design tools with clear descriptions
2. Consolidate related tools
3. Use parameters for flexibility
4. Document inputs and outputs
5. Include examples
6. Monitor tool usage and effectiveness
