# Good Skill Examples

## Well-Structured Skills

### Example 1: Language Skill

**SKILL.md** (<200 lines):
- Core principles
- When to use
- Key patterns
- Reference to `references/advanced-patterns.md`

**references/advanced-patterns.md**:
- Detailed type patterns
- Advanced features
- Complex examples

### Example 2: Framework Skill

**SKILL.md** (<200 lines):
- Architecture overview
- Key principles
- When to use
- References to multiple reference files

**references/**:
- `components.md` - Component patterns
- `routing.md` - Routing patterns
- `forms.md` - Form handling
- `styling.md` - Styling patterns

### Example 3: Workflow Skill

**SKILL.md** (<200 lines):
- Workflow overview
- When to use
- Core steps
- Reference to scripts and references

**scripts/**:
- `setup.sh` - Setup script
- `validate.py` - Validation script

**references/**:
- `best-practices.md` - Detailed practices
- `troubleshooting.md` - Common issues

## Anti-Examples

### Bad: Monolithic Skill

- 1000+ line SKILL.md with everything
- No references directory
- Hard to navigate
- Slow activation

### Bad: Over-Fragmented

- SKILL.md too minimal (10 lines)
- 50+ tiny reference files
- No clear structure
- Hard to understand

### Good: Balanced

- SKILL.md ~150 lines with clear structure
- 5-10 focused reference files
- Clear organization
- Fast activation
