---
name: cursor-best-practices
description: Best practices for working with Cursor. Use when learning how to effectively use Cursor features or optimizing your workflow.
---

# Cursor Best Practices

Best practices for working with Cursor to maximize productivity and code quality.

## Core Principles

- **Start with plans** - Use Plan Mode (Shift+Tab) for complex tasks
- **Manage context effectively** - Let agent find context, start new conversations when needed
- **Extend the agent** - Use Rules for static context, Skills for dynamic capabilities
- **Review carefully** - AI-generated code needs review like human code

## Key Workflows

- **Test-driven development** - Write tests first, iterate until passing
- **Codebase understanding** - Use agent to explore and learn codebases
- **Git workflows** - Automate common git operations with commands
- **Parallel agents** - Run multiple agents simultaneously for comparison

## References

For detailed guidance, see:
- `references/planning.md` - Plan mode and starting with plans
- `references/context.md` - Managing context and conversations
- `references/extending.md` - Rules vs Skills, extending agent
- `references/workflows.md` - TDD, codebase understanding, git workflows
- `references/reviewing.md` - Code review strategies
- `references/parallel-agents.md` - Running agents in parallel
