# Sonos Search Tips and Patterns

## Live Performance Indicators

### Venue Names to Look For
When searching for live performances, these venue names in search results indicate live recordings:
- Massey Hall (Toronto)
- The Troubadour (Los Angeles)
- Red Rocks (Colorado)
- The Fillmore (San Francisco)
- The Ryman (Nashville)
- Nashville (various venues)
- Unplugged (MTV series)
- Live at [venue name]

### Search Term Strategies

**To find live versions:**
- Include "live" in search query
- Include "unplugged" for acoustic performances
- Add venue names if looking for specific performances
- Look for "In Concert" in album titles

**To find covers:**
- Use format: "[song title] cover by [artist]"
- Include "version" to find alternate interpretations

**To find specific album versions:**
- Include album name in search to get that specific version
- Use year if multiple versions exist

## Common Artist Name Variations

Some artists have different names or spellings that affect search results:

- Bruce Springsteen: "Springsteen", "The Boss", "Bruce"
- Neil Young: May appear with "Neil Young & Crazy Horse"
- Jackson Browne: Sometimes "Jackson C. Browne"
- Lucinda Williams: Consistent spelling important
- Patty Griffin: Note "Patty" not "Patti"

## Search Quality Tips

**Better results:**
- Use artist name + most distinctive part of song title
- For common song titles, add album name or artist name
- For deep cuts, search album name first, then select from album tracks

**Avoid:**
- Too many search terms (keep it 3-4 words max)
- Generic words like "song", "music", "track"
- Punctuation that may not match metadata

## Building Effective Mixes

**Chronological approach:**
- Mix different eras from same artist
- Combine early and late career tracks

**Genre coherence:**
- Keep similar genres together for flow
- Consider energy levels (build up or wind down)

**Variety patterns:**
- Alternate male/female vocals
- Mix tempos (fast, medium, slow rotation)
- Include one "surprise" track per mix

## Troubleshooting Searches

**If search returns too many results:**
- Add more specific terms (album name, year)
- Include full artist name

**If search returns no results:**
- Simplify query (remove extra terms)
- Try alternate spellings
- Search by album instead of track

**If wrong version appears:**
- Add "studio" for studio versions
- Add "original" for original recordings
- Specify album name to get desired version
