---
name: deep-research
description: Use for multi-day technology evaluations, competitive analysis, architectural exploration, best practices research, or major strategic decisions requiring comprehensive investigation and stakeholder reports. Unlike spike (time-boxed hours), supports extended multi-day investigation.
---

# Deep Research

Comprehensive investigation that informs major decisions. Produces structured reports for stakeholders.

## Deep Research vs Spike

| | Spike | Deep Research |
|-|-------|---------------|
| Duration | Hours | Days |
| Scope | Single question | Multiple questions |
| Output | GO/NO-GO decision | Comprehensive report |
| Depth | Proof of concept | Full evaluation |

## When NOT to Use

- **Single focused question answerable in hours** — Use `spike` for quick GO/NO-GO decisions
- **Reviewing existing code/architecture** — Use `architecture-review` for structural analysis of what's already built
- **Known technology, just need implementation guidance** — Read docs or use relevant skill directly

## Key Principles

- Define research questions and success criteria upfront
- Evaluate multiple options against consistent criteria
- Synthesize findings into actionable recommendations
- Track progress through ohno for multi-session continuity

## Quick Start Checklist

1. Define research questions (what decisions need data?)
2. Set evaluation criteria (what matters for comparison?)
3. Gather sources (docs, benchmarks, case studies, experiments)
4. Compare options against criteria systematically
5. Synthesize findings and form recommendations
6. Present report with clear decision guidance

## References

| Reference | Description |
|-----------|-------------|
| [research-types.md](references/research-types.md) | Technology evaluation, competitive analysis, best practices |
| [source-quality.md](references/source-quality.md) | Evaluating source reliability and relevance |
| [synthesis-patterns.md](references/synthesis-patterns.md) | Comparison matrices, decision frameworks |
| [research-report-template.md](references/research-report-template.md) | Template for comprehensive research reports |
| [comparison-matrix-template.md](references/comparison-matrix-template.md) | Template for multi-option comparison scoring |
