---
name: documentation
description: Create and maintain technical documentation including READMEs, API docs, architecture decision records (ADRs), and user guides. Use this skill when writing project documentation, documenting APIs, recording architectural decisions, creating how-to guides, or establishing documentation standards.
---

# Documentation

Create clear, maintainable technical documentation that serves your audience.

## Key Principles

- **Documentation as code** — docs live with code, version with code, review with code
- **Audience-first writing** — write for who's reading, not what you know
- **Maintainability over completeness** — inaccurate docs are worse than no docs
- **Link to source of truth** — don't duplicate information across docs

## Quick Start Checklist

1. Identify documentation type (README, API docs, ADR, user guide)
2. Determine audience (all users, developers, team, contributors)
3. Follow type-specific template from references
4. Include working examples (test them!)
5. Link to related documentation

## Documentation Types

| Type | When to Use | Audience |
|------|-------------|----------|
| README | Project entry point | All users |
| API Docs | Endpoint reference | Developers |
| ADR | Major decisions | Team/future devs |
| User Guide | Task completion | End users |

## References

| Reference | Description |
|-----------|-------------|
| [readme-guide.md](references/readme-guide.md) | README templates, section patterns, badges |
| [api-docs.md](references/api-docs.md) | API documentation patterns, OpenAPI integration |
| [adr-guide.md](references/adr-guide.md) | Architecture Decision Record format and workflow |
| [diagrams.md](references/diagrams.md) | Mermaid diagram patterns for common scenarios |
| [readme-template.md](references/readme-template.md) | Template for project README files |
| [adr-template.md](references/adr-template.md) | Template for Architecture Decision Records |
