---
name: issue-tree-builder
description: McKinsey-style issue tree framework for breaking down complex problems into MECE (Mutually Exclusive, Collectively Exhaustive) components. Use when users need to decompose strategic questions, structure analysis, create work plans, or prepare for case interviews. Apply hypothesis-driven approach to problem-solving.
---

# Issue Tree Builder

A structured approach to breaking down complex problems into actionable components using MECE principles.

## What is an Issue Tree?

A visual hierarchy that decomposes a governing question into increasingly specific sub-questions or components. Used in consulting to structure analysis, prioritize workstreams, and develop hypotheses before solutioning.

**Key characteristics:**
- Top-down structure (question → branches → sub-branches)
- MECE at each level (branches don't overlap, collectively cover the problem)
- Hypothesis-driven (based on initial beliefs about what matters)
- Actionable at terminal branches (lowest level = things you can analyze or do)

## Framework Components

**Level 0: Governing Question**
- The main strategic question to answer
- Must be specific and answerable
- Examples: "How to grow revenue 40% in 12 months?", "Should we enter the European market?"

**Level 1-2: Major Branches (typically 3 branches)**
- Consulting "rule of 3" - aim for three major dimensions
- Decompose to fundamentals first, not actions
- Must be MECE
- Often structured around fundamental problem drivers:
  - **Revenue problems**: Price × Quantity × Pipeline/funnel
  - **Profit problems**: Revenue - Cost
  - **Growth problems**: New customers, Expand existing, New products
  - **Market entry**: Market attractiveness, Competitive position, Capability to win

**Level 2: Sub-branches**
- One more level of decomposition from major branches
- 2 levels total from governing question
- Terminal branches should be clear hypotheses to test with data
- Keep simple and focused

## Core Principles

**MECE (Mutually Exclusive, Collectively Exhaustive)**
- No overlap between branches at same level
- Together they cover all relevant aspects
- Test: Can you classify any answer element into exactly one branch?

**Hypothesis-Driven with Data**
- Start with beliefs about what matters most
- Structure tree to test key hypotheses
- Each terminal branch = hypothesis to prove/disprove with data
- Back findings with analysis
- Example: "Hypothesis: Pricing 20% below market drives volume" → Test with data

**Actionable Terminal Branches**
- Lowest level = clear hypotheses to test
- Should be obvious what analysis proves/disproves it
- Examples: "Current pricing is 20% below competitors", "Conversion drops 50% at checkout", "Customer acquisition cost exceeds LTV"

**Simplicity**
- 2 levels total from governing question
- Consulting "rule of 3" - aim for 3 major branches (3-5 acceptable)
- Prefer clarity and focus over completeness

## Example: E-commerce Revenue Growth

**Governing Question:** How can we increase e-commerce revenue by 50% in 18 months?

**Issue Tree (Revenue = Price × Quantity × Conversion):**
```
How to increase revenue 50% in 18 months?
├─ Average Order Value (Price)
│  ├─ Current pricing 15% below market - hypothesis: can increase without volume loss
│  ├─ Cart contains 1.8 items vs industry 2.5 - hypothesis: cross-sell opportunity
│  └─ Premium SKUs = 10% of sales vs 30% competitor - hypothesis: mix shift possible
├─ Traffic Volume (Quantity)
│  ├─ Paid CAC = $45 vs LTV $120 - hypothesis: can 2x spend profitably
│  ├─ Organic = 20% vs 40% competitor - hypothesis: SEO underinvested
│  └─ Repeat rate 25% vs 45% industry - hypothesis: retention issue
└─ Conversion Rate (Pipeline efficiency)
   ├─ Checkout abandonment 68% vs 58% benchmark - hypothesis: friction in checkout
   ├─ Mobile converts 1.2% vs desktop 3.5% - hypothesis: mobile UX broken
   └─ First-time visitor 0.8% vs repeat 4.2% - hypothesis: trust/credibility gap
```

**Each branch = testable hypothesis backed by data analysis**

## Usage Patterns

**When creating an issue tree:**
1. Start with the governing question (Level 0)
2. Decompose to fundamentals - not actions (Level 1, aim for 3 branches)
3. Identify 2-3 key hypotheses under each branch (Level 2)
4. Verify MECE at each level
5. Ensure each terminal branch is testable with data

**When reviewing an issue tree:**
- Is the governing question specific and answerable?
- Does Level 1 break down to fundamentals (not actions)?
- Are branches at each level MECE?
- Does each terminal branch represent a clear hypothesis?
- Can you test each hypothesis with data?
- Is it 2 levels from the governing question?

**Common use cases:**
- Beginning of client engagement or strategic initiative
- Case interview preparation and practice
- Structuring analysis before diving into data
- Creating work plans with clear workstreams

## Prioritization: Where to Start

After building the issue tree, prioritize which branches to tackle first. State: "We will start here because..." with data-backed reasoning and business impact.

**Prioritization Criteria:**

**Impact and Effort**
- Quantify potential impact on the governing question
- Consider implementation effort and cost
- Example: "Start with pricing - 10% increase = $5M revenue with minimal implementation cost"

**Data-Backed Reasoning**
- Reference benchmarks, customer data, financial models
- Example: "Checkout abandonment 68% vs 58% benchmark = immediate 15% conversion gain if fixed"

**Quick Framework:**
```
High Impact + Low Effort = Start here
High Impact + High Effort = Plan carefully, Phase 2
Low Impact + Low Effort = Do if time permits
Low Impact + High Effort = Deprioritize
```

**Example Prioritization Statement:**
"Start with checkout abandonment (Branch 3.1) because:
1. 68% vs 58% benchmark = 10 percentage point gap
2. Fixing yields immediate 15% conversion lift = $2M revenue
3. 4-week implementation with known solutions
4. De-risks overall 50% growth target"

**Dependencies:**
- Some hypotheses must be tested before others
- Start with highest conviction hypotheses

## Common Mistakes to Avoid

- **Not MECE**: Overlapping branches or missing key dimensions
- **Actions instead of fundamentals**: Level 1 should decompose problem (Price × Quantity), not list solutions
- **Too many branches**: Stick to rule of 3 where possible (3-5 max)
- **Too deep**: Should be 2 levels from governing question
- **Not testable**: Terminal branches must be provable/disprovable with data
- **Wrong starting question**: Vague or non-specific governing question
- **Missing the hypothesis**: Each branch should represent something testable

## Tips for Effective Issue Trees

**Start with the right question**
- "How to grow revenue?" → Good starting point
- "What should we do?" → Too vague, refine first

**Use natural problem structures**
- Profit = Revenue - Cost
- Growth = New customers + Expansion + New products
- Market entry = Attractiveness + Competitive position + Capability

**Think hypothesis-first**
- What do you believe is most important?
- Structure tree to test that belief
- Don't boil the ocean

**Make it visual**
- Best on paper or whiteboard first (quick sketching)
- PowerPoint: Use SmartArt → Hierarchy for clean diagrams
- Diagramming tools (Lucidchart, Miro, etc.) for team collaboration
- ASCII tree format works well for documentation
- Makes MECE gaps more obvious when visual

**Iterate**
- First draft won't be perfect
- Refine based on initial analysis
- Add/remove branches as you learn
