---
name: scpr-framework
description: SCPR (Situation-Complication-Problem-Recommendation) framework for structured problem solving and executive communication. Use when users need to structure strategic arguments, analyze business situations, create executive summaries, or develop clear problem statements using McKinsey-style communication. Apply when structuring recommendations, writing memos, or organizing strategic thinking.
---

# SCPR Framework

A structured approach to problem-solving and executive communication used in management consulting.

## Framework Components

**S - Situation**: Current state of the market/business
- What is the lay of the land?
- Establish baseline context
- Describe the stable environment before changes

**C - Complication**: Recent shift or change
- What has changed recently?
- New market dynamics (AI boom, regulatory changes, competitive threats)
- The catalyst that creates urgency

**P - Problem**: Crisp question to solve
- What specific strategic question must be answered?
- Common examples: "How to grow revenue?", "How to enter new market?", "How to reduce costs?"
- Must be specific and answerable

**R - Recommendation**: Proposed actions
- What should be done and by when?
- Priority actions to address the problem
- Can be structured as issue tree branches (doesn't have to be only high-priority items)
- Specific, actionable, time-bound

## Core Principles

**MECE (Mutually Exclusive, Collectively Exhaustive)**
- Recommendations should not overlap
- Together they should cover all necessary actions
- Each recommendation addresses distinct aspect of the problem

**Clarity**
- Each section should be concise
- Problem statement must be answerable
- Recommendations must be actionable

## Example: Tech Startup Product Pivot

**Situation**
Series B SaaS startup with $15M ARR selling project management software to creative agencies and marketing firms. Product focuses on task management, resource allocation, and client collaboration. 200 agency customers with average contract size $75K. Historically strong product-market fit with 25% YoY growth and 90% gross retention.

**Complication**
AI-powered tools like ChatGPT, Notion AI, and Claude emerging as workflow automation alternatives. Customer usage metrics declining 15% over last 6 months. Exit interviews reveal agencies using AI for project briefs, status updates, and resource planning - core features of current product. Three enterprise deals ($500K pipeline) paused citing "evaluating AI-first solutions."

**Problem**
How should we reposition the product and business model to return to 25%+ growth within 12 months while competing against general-purpose AI tools?

**Recommendations**
1. **Product**: Launch AI-native workflow engine by Q2 2025
   - Integrate LLM for automated project scoping and task breakdown
   - AI-powered resource matching based on skills and availability
   - Differentiate on agency-specific context (brand guidelines, client history, creative workflows)

2. **Positioning**: Shift from "project management" to "AI-augmented agency operations" by Q1 2025
   - Rebrand messaging around AI that understands agency workflows
   - Emphasize integration advantages over general tools
   - Target gap: ChatGPT lacks agency-specific memory and processes

3. **Pricing**: Introduce usage-based AI tier by Q2 2025
   - Base platform remains flat fee ($75K)
   - AI features charged per automation/generation
   - Capture value from high-usage customers, protect downside

## Usage Patterns

**When creating SCPR structure:**
1. Start with Situation (establish baseline)
2. Identify Complication (what changed?)
3. Frame Problem as specific question
4. Develop MECE Recommendations with timeline

**When analyzing existing content:**
1. Extract facts into S/C/P/R categories
2. Test Problem for specificity
3. Verify Recommendations are MECE
4. Add timelines if missing

**When reviewing SCPR:**
- Is Situation necessary context only (not exhaustive)?
- Is Complication recent and urgent?
- Is Problem answerable and specific?
- Are Recommendations mutually exclusive and collectively exhaustive?
- Does each Recommendation include "by when"?

## Common Mistakes to Avoid

- **Situation too detailed**: Keep to essential context only
- **Complication = Problem**: They're different. Complication is "what changed", Problem is "what question to solve"
- **Vague Problem**: "Improve business" is too broad. "Increase revenue 40% in 12 months" is specific
- **Overlapping Recommendations**: Ensure MECE structure
- **No timelines**: Always include "by when" in Recommendations
