# Accessibility checklist (practical baseline)

This is a pragmatic checklist for common web UIs.

## Keyboard

- Everything interactive is reachable by Tab/Shift+Tab
- Focus order matches visual order
- Focus is visible (not removed)
- Modals trap focus and return focus on close
- Escape closes dialogs (when appropriate)

## Forms

- Inputs have programmatic labels
- Error messages are associated to fields
- Required fields are indicated in text

## Semantics

- Headings are in logical order
- Buttons are buttons; links navigate
- Icon-only buttons have accessible names

## Contrast & text

- Text contrast is acceptable
- Avoid tiny text on mobile
- Do not communicate state with color only

## Motion

- Avoid essential motion; respect reduced motion preferences when possible
