# Changelog - agentdb-state-manager

All notable changes to the AgentDB State Manager skill will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

### Planned
- AgentDB tool integration (when available in Gemini Code)
- Performance benchmarks for token savings

## [1.1.0] - 2025-11-16

### Added
- **MIT Agent Synchronization Pattern schema** (Issue #159 - Phase 1)
  - agentdb_sync_schema.sql: 3 tables for agent coordination
    - agent_synchronizations: Master sync registry
    - sync_executions: Detailed execution log with PHI tracking
    - sync_audit_trail: Immutable HIPAA/FDA/IRB audit trail
  - 20+ indexes for query performance optimization
  - 4 pre-built views for common queries
  - Schema metadata tracking for future migrations
- **Healthcare compliance** (HIPAA/FDA 21 CFR Part 11/IRB)
  - PHI access tracking with mandatory justification
  - APPEND-ONLY audit trail (FDA electronic records requirement)
  - Electronic signature support (actor, timestamp, event type)
  - Consent tracking and data minimization evidence
- **Test suite** with ≥80% coverage
  - test_schema_migration.py: 13 test cases (100% pass rate)
  - Validates tables, indexes, views, constraints, foreign keys
  - Tests APPEND-ONLY behavior (application-level enforcement)
  - Idempotent test execution with cleanup
- **Comprehensive documentation**
  - phase1_hipaa_compliance.md: HIPAA/FDA/IRB compliance validation
  - schema_integration_guide.md: Integration guide with examples
  - Migration path from existing agentdb v1.0.0 (coexistence strategy)
- **schemas/ directory** for SQL schema files
- **docs/ directory** for compliance and integration documentation

### Changed
- Updated CHANGELOG.md with Phase 1 deliverables

### Migration Notes
- **Backward compatible:** New sync schema coexists with existing workflow_records table
- **No breaking changes:** Existing agentdb-state-manager scripts unchanged
- **Migration:** Run agentdb_sync_schema.sql to add 3 new tables to existing database
- **Rollback:** Drop sync tables if needed (workflow_records unaffected)

### Blocks Resolved
- Issue #160 (Phase 2: Sync Coordinator) - schema ready for consumption
- Issue #161 (Phase 3: Integration) - schema ready for integration

## [1.0.0] - 2025-11-02

### Added
- Initial release of agentdb-state-manager skill
- Persistent state management using AgentDB (DuckDB)
- Read-only analytics mode (TODO_*.md files remain source of truth)
- Cross-phase (Utilities) integration for all workflow phases
- Canonical state definitions in workflow-states.json (v5.2.0)
- Five core scripts:
  - init_database.py: Initialize AgentDB schema
  - sync_todo_to_db.py: Sync TODO files to AgentDB
  - query_state.py: Query current workflow state
  - analyze_metrics.py: Historical analytics
  - checkpoint_manager.py: Context checkpoint management
- Immutable append-only record design
- Token efficiency: 89% reduction for complex queries
- Complete documentation (SKILL.md, GEMINI.md, README.md)

---

## Version History

| Version | Date       | Type  | Description |
|---------|------------|-------|-------------|
| 1.1.0   | 2025-11-16 | MINOR | MIT Agent Sync Pattern schema + HIPAA/FDA/IRB compliance |
| 1.0.0   | 2025-11-02 | MAJOR | Initial release |

---

## Related Documentation

- **[SKILL.md](SKILL.md)** - Complete skill documentation
- **[GEMINI.md](GEMINI.md)** - Gemini Code context
- **[README.md](README.md)** - Human-readable overview
- **[templates/workflow-states.json](templates/workflow-states.json)** - State definitions
