# Storage APIs

Local storage on user's device, persists across sessions.

## setItem
Save data to storage.
```js
import { setItem } from "zmp-sdk/apis";

await setItem({
  data: {
    key1: "value1",
    key2: { nested: "object" },
    key3: [1, 2, 3]
  }
});
```

## getItem
Retrieve stored data.
```js
import { getItem } from "zmp-sdk/apis";

const { key1, key2 } = await getItem({
  keys: ["key1", "key2"]
});
```

## removeItem
Delete specific keys.
```js
import { removeItem } from "zmp-sdk/apis";

await removeItem({
  keys: ["key1", "key2"]
});
```

## clear
Clear all storage.
```js
import { clear } from "zmp-sdk/apis";

await clear({});
```

## getStorageInfo
Get storage usage info.
```js
import { getStorageInfo } from "zmp-sdk/apis";

const { keys, currentSize, limitSize } = await getStorageInfo({});
```

## Best Practices
- Store only essential data
- Use JSON for complex objects
- Check storage limits before saving
- Handle errors for quota exceeded

## Example: Address Book Cache
```js
async function getAddresses() {
  const { addresses } = await getItem({ keys: ["addresses"] });
  return addresses || [];
}

async function saveAddress(address) {
  const addresses = await getAddresses();
  addresses.push(address);
  await setItem({ data: { addresses } });
  return addresses;
}
```
