# Getting Started with Zalo Mini App

## Prerequisites
- Node.js installed
- Zalo Developer account at [Zalo for Developers](https://developers.zalo.me/)

## Create Zalo App & Mini App
1. Login to [Zalo for Developers](https://developers.zalo.me/), create a Zalo App
2. In Settings, activate the app
3. Go to [Mini App Center](https://miniapp.zaloplatforms.com/), select Zalo App, create Mini App
4. Note the Mini App ID for development

## Install Dev Tools
```bash
npm install -g zmp-cli
```

## Create New Project
```bash
zmp create my-app
cd my-app
zmp start
```

## Project Structure
```
my-app/
├── src/
│   ├── pages/          # Page components
│   ├── components/     # Reusable components
│   └── app.js          # Entry point
├── app-config.json     # Mini App configuration
├── .env               # Environment variables
└── package.json
```

## app-config.json
```json
{
  "app": {
    "title": "My App",
    "headerColor": "#1843EF",
    "headerTitle": "App Title",
    "textColor": "white",
    "leftButton": "back",
    "statusBar": "normal",
    "actionBarHidden": false
  },
  "listCSS": [],
  "listSyncJS": [],
  "listAsyncJS": []
}
```

| Field | Description |
|-------|-------------|
| headerColor | Navigation bar background color |
| headerTitle | Title displayed on navigation bar |
| textColor | Text color ("white" or "black") |
| leftButton | "back" or "home" |
| statusBar | "normal" or "fullscreen" |
| actionBarHidden | Hide navigation bar |

## Deploy & Test
```bash
zmp deploy           # Deploy to testing
zmp login            # Login to Zalo
```

## Test on Device
1. Open Zalo app
2. Scan QR code from Mini App Center
3. Or use link: `https://zalo.me/s/{mini-appId}`

## Convert Web App to Mini App
```bash
cd your-web-app
zmp init
# Select "Using ZMP to deploy only"
```

Update root element selector to `#app`:
```js
const root = createRoot(document.getElementById("app"));
```

For Vite, set `base: "./"` in vite.config.js.
For Webpack, use `window.APP_VERSION` for public path.

## Publishing
1. Go to Mini App Center > Version Management
2. Submit version for review
3. After approval, click Publish

See [design-guidelines.md](./design-guidelines.md) for UI requirements.
