# ZaUI Layout Components

## App
Root component wrapping entire app.
```jsx
import { App } from "zmp-ui";

<App>
  {/* Your app content */}
</App>
```

## Page
Page container with header support.
```jsx
import { Page, Header } from "zmp-ui";

<Page>
  <Header title="Page Title" />
  <div className="page-content">
    {/* Content */}
  </div>
</Page>
```

Props:
- `hideScrollbar` - Hide scrollbar
- `restoreScrollOnBack` - Restore scroll position

## Header
Custom header component.
```jsx
import { Header } from "zmp-ui";

<Header
  title="My Page"
  showBackIcon={true}
  onBackClick={() => navigate(-1)}
/>
```

Props:
- `title` - Header title
- `showBackIcon` - Show back button
- `onBackClick` - Back button handler

## BottomNavigation
Fixed bottom tab bar.
```jsx
import { BottomNavigation } from "zmp-ui";

<BottomNavigation fixed>
  <BottomNavigation.Item
    key="home"
    label="Home"
    icon={<Icon icon="zi-home" />}
    activeIcon={<Icon icon="zi-home-solid" />}
  />
  <BottomNavigation.Item
    key="profile"
    label="Profile"
    icon={<Icon icon="zi-user" />}
    activeIcon={<Icon icon="zi-user-solid" />}
  />
</BottomNavigation>
```

## Tabs
Tab panels.
```jsx
import { Tabs } from "zmp-ui";

<Tabs defaultActiveKey="tab1">
  <Tabs.Tab key="tab1" label="Tab 1">
    Content 1
  </Tabs.Tab>
  <Tabs.Tab key="tab2" label="Tab 2">
    Content 2
  </Tabs.Tab>
</Tabs>
```

## ZMPRouter / AnimationRoutes
Router with page transitions.
```jsx
import { ZMPRouter, AnimationRoutes, Route } from "zmp-ui";

<ZMPRouter>
  <AnimationRoutes>
    <Route path="/" element={<HomePage />} />
    <Route path="/profile" element={<ProfilePage />} />
  </AnimationRoutes>
</ZMPRouter>
```
