# ZaUI Overlay Components

## Modal
Dialog modal.
```jsx
import { Modal, Button } from "zmp-ui";

const [visible, setVisible] = useState(false);

<Button onClick={() => setVisible(true)}>Open Modal</Button>

<Modal
  visible={visible}
  title="Confirm"
  onClose={() => setVisible(false)}
  actions={[
    { text: "Cancel", close: true },
    { text: "OK", close: true, highLight: true }
  ]}
>
  Are you sure you want to proceed?
</Modal>
```

Props:
- `visible` - Show/hide modal
- `title` - Modal title
- `onClose` - Close handler
- `actions` - Footer buttons
- `maskClosable` - Click mask to close

## Sheet
Bottom sheet.
```jsx
import { Sheet, Button } from "zmp-ui";

const [visible, setVisible] = useState(false);

<Button onClick={() => setVisible(true)}>Open Sheet</Button>

<Sheet visible={visible} onClose={() => setVisible(false)} height={300}>
  <Sheet.Header title="Select Option" />
  <Sheet.Content>
    {/* Sheet content */}
  </Sheet.Content>
</Sheet>
```

Props:
- `visible`, `onClose`
- `height` - Sheet height
- `swipeToClose` - Enable swipe gesture

## ActionSheet
Action menu.
```jsx
import { ActionSheet } from "zmp-ui";

const [visible, setVisible] = useState(false);

<ActionSheet
  visible={visible}
  onClose={() => setVisible(false)}
  actions={[
    { text: "Edit", onClick: handleEdit },
    { text: "Delete", danger: true, onClick: handleDelete },
    { text: "Cancel", close: true }
  ]}
/>
```

## SnackbarProvider
Toast notifications.
```jsx
import { SnackbarProvider, useSnackbar, App } from "zmp-ui";

// Wrap app
<App>
  <SnackbarProvider>
    <YourApp />
  </SnackbarProvider>
</App>

// Use in component
function MyComponent() {
  const { openSnackbar } = useSnackbar();

  const showMessage = () => {
    openSnackbar({
      text: "Operation successful!",
      type: "success",  // "success" | "error" | "warning" | "info"
      duration: 3000
    });
  };

  return <Button onClick={showMessage}>Show Toast</Button>;
}
```
