# ZaUI Components

## Installation
```bash
npm install zmp-ui
```

## Usage
```js
import { Button, Input, Modal } from "zmp-ui";
import "zmp-ui/zaui.css";
```

## Categories

### Layout
See [zaui-layout.md](./zaui-layout.md)
- `App` - Root wrapper
- `Page` - Page container
- `Header` - Custom header
- `BottomNavigation` - Tab bar
- `Tabs` - Tab panels
- `ZMPRouter` - Router integration

### Display
See [zaui-display.md](./zaui-display.md)
- `Avatar` - User avatar
- `Calendar` - Date display
- `Icon` - Zalo icons
- `ImageViewer` - Image gallery
- `List` - List items
- `Progress` - Progress bar
- `Spinner` - Loading indicator
- `Swiper` - Carousel
- `Text` - Typography

### Form
See [zaui-form.md](./zaui-form.md)
- `Button` - Buttons
- `Input` - Text input
- `Password` - Password input
- `Search` - Search input
- `TextArea` - Multiline input
- `OTP` - OTP input
- `Select` - Dropdown
- `Picker` - Scroll picker
- `DatePicker` - Date selection
- `Switch` - Toggle
- `Checkbox` - Checkboxes
- `Radio` - Radio buttons
- `Slider` - Range slider

### Overlay
See [zaui-overlay.md](./zaui-overlay.md)
- `Modal` - Dialog modal
- `Sheet` - Bottom sheet
- `ActionSheet` - Action menu
- `SnackbarProvider` - Toast notifications

## Design Tokens

### Colors
Primary: `#006AF5` (Zalo Blue)
Background: `#FFFFFF`, `#F4F5F6`
Text: `#141415`, `#767A7F`
Success: `#00C853`
Warning: `#FFA000`
Error: `#FF3B30`

### Spacing (4px base)
- U1: 4px, U2: 8px, U3: 12px
- U4: 16px, U6: 24px, U8: 32px

### Corner Radius
- Small: 4px
- Medium: 8px
- Large: 12px
- XLarge: 16px

### Typography
Font: System default
Sizes: 12px, 14px, 16px, 18px, 20px, 24px
