---
name: ask-user-choice
description: ユーザーに質問や確認をする際に毎回発動してください。自由回答形式ではなく、明確な選択肢（1質問あたり2-4個）を持つAskUserQuestionツールを使用し、ユーザーの入力負担を軽減して意思決定を迅速化します。柔軟性のためmultiSelect trueをデフォルトにしてください。
allowed-tools: AskUserQuestion
---

# Ask User Choice Skill

## 目的

このスキルは`AskUserQuestion`ツールの使用を推進し、ユーザーの入力負担を軽減して対話をより効率的にします。テキスト入力が必要な自由回答形式ではなく、ワンクリックで選択できる構造化された選択肢を提供してください。

## 使用タイミング

<trigger>

以下の場合にこのスキルを発動してください：
- ユーザーの入力や好みを取得する
- 曖昧な要件を明確化する
- 実装の選択肢を提示する（ライブラリ、アーキテクチャ、アプローチなど）
- 複数のタスクがある場合に優先順位を決定する
- 作業完了後に次のアクションを提案する

</trigger>

## ベストプラクティス

### 1. 良い質問の構造

各質問には以下を含めること：

- **明確な質問文**: 疑問符で終わり、具体的であること
- **簡潔なheader**: 短いラベル。例：「ライブラリ」「アプローチ」
- **選択肢**: それぞれにラベルと詳細な説明を付ける
- **multiSelect**: **デフォルトで`true`に設定**（柔軟性のため、ユーザーは1つまたは複数選択可能）

### 2. 充実した詳細な説明文を書く

説明文は長くてOK。情報量を充実させること。

良い選択肢の構造：

```json
{
  "label": "短い選択肢名",
  "description": "コンテキスト、トレードオフ、影響を含む詳細な説明。\n\n段落区切りには\\n\\nを使って可読性を向上させる。\n\n十分な情報を提供して、情報に基づいた意思決定を可能にする。"
}
```

- `\n\n`で段落区切りを使う（可読性が大幅に向上）
- コンテキスト、メリット・デメリット、影響を含める
- 詳細を出し惜しみしない - ユーザーは簡潔すぎる説明より包括的な情報を好む
- **Markdown記法の制限**:
  - `**bold**`、`*italic*`、`` `code` ``などは使えない（そのまま表示される）
  - 箇条書き（`-`）は装飾されないがそのまま表示されるので、可読性向上のために使用OK

### 3. multiSelectをデフォルトで使用

**特に理由がない限り`multiSelect: true`をデフォルトに**

✅ **`multiSelect: true`を使用（推奨デフォルト）**:

- ほとんどのシナリオで柔軟性の恩恵がある
- ユーザーは1つだけ選びたければ1つだけ選べる
- 該当する場合は複数の選択肢を組み合わせられる
- よりユーザーフレンドリーで制約が少ない

⚠️ **`multiSelect: false`を使うのは以下の場合のみ**:

- 選択肢が厳密に相互排他的
- 複数選択すると論理的な矛盾が生じる
- 質問の性質上、単一選択が本質的に必要

## 使用例

<examples>

### 例1: 実装アプローチ選択（詳細な説明文付き）

<example>

```json
{
  "question": "どのJavaScriptフレームワークを使用しますか？",
  "header": "Framework",
  "multiSelect": true,
  "options": [
    {
      "label": "React + TypeScript",
      "description": "仮想DOMを使用した高速レンダリングを実現する、最も人気のあるJavaScriptフレームワーク。\n\nTypeScriptと組み合わせることで型安全性が向上し、大規模プロジェクトでも保守性が高まる。\n\nコンポーネントベースの設計で再利用性が高く、豊富なエコシステム（React Router, Redux, Next.js等）が利用できる。\n\n学習コストは中程度で、ドキュメントやコミュニティサポートが充実している。"
    },
    {
      "label": "Vue.js + Composition API",
      "description": "学習曲線が穏やかで初心者にも取り組みやすいフレームワーク。\n\nComposition APIを使用することで、React Hooksに近いロジックの再利用が可能になる。\n\nテンプレート構文が直感的でHTMLに近い書き方ができ、公式の状態管理ライブラリPiniaやルーティングライブラリVue Routerが統合されている。\n\nパフォーマンスも優れており、中小規模から大規模まで幅広く対応できる。"
    },
    {
      "label": "Svelte + SvelteKit",
      "description": "コンパイル時にコードを最適化するため、ランタイムのオーバーヘッドが極めて少なく、高速なアプリケーションを構築できる。\n\n仮想DOMを使わず、ビルド時に効率的な命令型コードに変換される。\n\nSvelteKitを使用することでSSRやSSG、ルーティングなどの機能が統合されている。\n\nコード量が少なく、バンドルサイズが小さいのも大きなメリット。ただし、エコシステムはReactやVueと比べるとまだ小さい。"
    }
  ]
}
```

</example>

### 例2: 複数機能選択（multiSelect推奨）

<example>

```json
{
  "question": "どの機能を実装しますか？",
  "header": "Features",
  "multiSelect": true,
  "options": [
    {
      "label": "ダークモード",
      "description": "ライトモードとダークモードの切り替え機能を追加。\n\n- アクセシビリティが向上\n- 低照度環境でのユーザーの快適性が改善\n- 目の疲労を軽減\n\n実装要件:\n- CSS変数の設定\n- 状態管理（localStorage等）\n- テーマ切り替えUI"
    },
    {
      "label": "キーボードショートカット",
      "description": "パワーユーザー向けにキーボードナビゲーションとショートカットを有効化。\n\n頻繁に使用するユーザーの生産性が大幅に向上する。\n\nブラウザのショートカットとの衝突を避けるための慎重な設計が必要。"
    },
    {
      "label": "PDF出力",
      "description": "コンテンツをPDFファイルとしてエクスポートできる機能。\n\nレポート、ドキュメント、オフライン共有に便利。\n\nPDF生成ライブラリ（jsPDF、pdfmake等）が必要。"
    }
  ]
}
```

</example>

### 例3: タスク優先順位（multiSelect falseのレアケース）

<example>

```json
{
  "question": "最初にどのタスクから始めますか？",
  "header": "Priority",
  "multiSelect": false,
  "options": [
    {
      "label": "認証バグの修正",
      "description": "🔴 最優先 - 現在ユーザーがログインできない状態。\n\n全ユーザーのアクセスをブロック中。修正予想時間：1-2時間。\n\n他の作業より先に即座に対処すべき。"
    },
    {
      "label": "新機能追加",
      "description": "🟡 中優先度 - 次スプリント向けにクライアントから要望あり。\n\n現在の機能をブロックしていない。予想時間：1-2日。\n\nクリティカルなバグ解決後にスケジュール可能。"
    },
    {
      "label": "コードリファクタリング",
      "description": "🟢 低優先度 - 保守性とコード品質を改善。\n\nユーザーへの即時影響なし。予想時間：3-4時間。\n\n機能開発の合間を埋めるのに適している。"
    }
  ]
}
```

</example>

</examples>

## 常に覚えておくこと

<important>

✅ **すべきこと**:

- 詳細な説明を使う（コンテキストとトレードオフを追加）
- `\n\n`で段落区切りを使い、可読性を向上させる
- 柔軟性のため`multiSelect: true`をデフォルトにする
- 各選択肢のlabelは短く、descriptionは充実させる
- **必要に応じて複数回質問する** - フォローアップが必要な場合は、最初の回答を得た後に再度AskUserQuestionを使用

❌ **してはいけないこと**:

- 簡潔すぎる説明 - ユーザーは情報に基づいた意思決定のため詳細を求める
- 選択肢が真に相互排他的でない限り`multiSelect: false`を使う
- フォローアップ質問を躊躇する - 推測よりも明確化の方が良い

</important>

## 複数ラウンドの質問

不明点が多い場合や段階的な明確化が必要な場合：

1. **関連する質問をグループ化**
2. **最初のバッチを聞く**、回答を待つ
3. **回答に基づいてフォローアップ質問**を必要に応じて行う
4. **すべての不確実性が解消されるまで繰り返す**

この段階的な質問アプローチは推奨されており、実装に進む前に徹底的な理解を確保するのに役立ちます。
