---
name: assembling-dev-team
description: 「開発チーム集合」「チームで実装」「チーム編成して」の言及時に使用。プランファイルに基づいて実装・リリース・レビュー・プラン更新の4担当をスポーンし、ステップごとに実装→レビュー→リリースのサイクルを回す。
---

# 開発チーム集合

このスキルはLLM agentであるリーダー（メインエージェント）が読み、チーム編成から実装完了までを自律的に進めるための指示書です。

**概要フロー**: フェーズ1（セットアップ）→ フェーズ2（プラン実装）→ フェーズ3（外部レビュー対応）

**最短サイクル**: 実装（implementer）→ レビュー（reviewer）+ リリース（release-manager）並列 → 次ステップ

**反復前提**: フェーズ2/3はチーム解散までユーザーの指摘に応じて繰り返し実行します。

## 禁止事項

<important>

- あなた（リーダー）は実装作業を行わない。タスク管理と調整のみ行う
- 一度に複数ステップを同時に実装させない。必ず1ステップずつ進める
- チームメンバーへの指示には、必ずプランファイルのパスと現在のステップ番号を含める
- チーム作成前にプランファイルの存在を確認する
- ユーザーの指示なしで勝手にチームを解散しない
- ユーザーに判断を仰ぐのは、メンバー間で意見が食い違うときや判断に迷うときのみ
- それ以外はリーダーが自律的に最後までタスクを進める
- プランファイルが見つからない場合はユーザーに報告して終了する
- メンバー間の通信はコミュニケーションパスのマトリクスに従う。許可されていない経路での直接通信は行わない

</important>

## 前提条件

<context name="prerequisites">

- `.claude_work/plans/*.md` に有効なプランファイルが1つ存在すること
- git worktree運用のため、単一のプランファイルが前提

</context>

## チーム構成

| 役割 | 名前 | 目的 |
|------|------|------|
| リーダー（あなた） | - | タスク管理・全体調整・ステップ分解 |
| 実装担当 | implementer | プランの1ステップを実装 |
| リリース担当 | release-manager | semantic-committingでコミット作成 → updating-pr-title-and-descriptionでPR更新 → monitor-ciでCIチェック。CI失敗時はimplementerと連携して自律的に対応 |
| レビュー担当 | reviewer | プランファイルに基づく簡易レビュー |
| プラン更新担当 | plan-updater | ユーザーの指摘をプランファイルに反映 |

各担当の詳細指示は references/ ディレクトリを参照:
- 実装担当: [references/implementer.md](references/implementer.md)
- リリース担当: [references/release-manager.md](references/release-manager.md)
- レビュー担当: [references/reviewer.md](references/reviewer.md)
- プラン更新担当: [references/plan-updater.md](references/plan-updater.md)

## コミュニケーションパス

リーダーをハブとした双方向通信構造。責任境界を明確にし、情報の流れを整理する。

|  | リーダー | implementer | reviewer | release-manager | plan-updater |
|---|:---:|:---:|:---:|:---:|:---:|
| リーダー | - | ○ | ○ | ○ | ○ |
| implementer | ○ | - | ○ | ○ | - |
| reviewer | ○ | ○ | - | - | - |
| release-manager | ○ | △ | - | - | - |
| plan-updater | ○ | - | - | - | - |

**通信ルール**:
- リーダーは全員と通信可能（ハブ）
- implementer → reviewer/release-manager は直送可（実装完了の迅速報告のため）。ただし、直送時はリーダーにも同報すること（進捗把握のため）
- reviewer → implementer は指摘対応のため許可。指摘時はリーダーにも共有すること
- release-manager と plan-updater は原則リーダー経由のみ（責任線の明確化）

**例外パス**（△マーク）:
- CI失敗時: release-manager → implementer への直送を許可（迅速な修正対応のため）。ただし、リーダーへの状況報告は必須

## 実行手順

<procedure>

## フェーズ1: 初期セットアップ

- **入力**: ユーザーの「開発チーム集合」発言
- **処理**: プラン特定 → チーム作成 → 分析 → タスク登録
- **出力**: チーム稼働状態（4名スポーン完了 + タスクリスト作成済み）

### 1.1 プランファイルの特定

```bash
ls .claude_work/plans/*.md
```

プランファイルが存在しない場合はユーザーに報告して終了。

プランファイルのパスを以下のように定義:

<plan-file>

```
<取得したプランファイルのパス>
```

</plan-file>

### 1.2 チーム作成とメンバースポーン

1. TeamCreate でチームを作成（team_name: "dev-team-{セッションID短縮}"）

2. 以下の共通テンプレートと役割別差分で4名をスポーン:

**共通テンプレート**:
```
あなたは開発チームの{役割名}です。

プランファイル: <plan-fileタグで定義されたパス>
詳細指示: まず {referencesファイルのパス} を Read ツールで読んでください。

そこに記載された手順に従って作業してください。
リーダーからの指示が来るまで待機してください。
作業完了後は必ずリーダーにメッセージで報告してください。
```

**役割別差分**:

| メンバー | 役割名 | referencesファイル | 待機内容 |
|----------|--------|-------------------|----------|
| implementer | 実装担当 | skills/assembling-dev-team/references/implementer.md | 各ステップの実装指示 |
| release-manager | リリース担当 | skills/assembling-dev-team/references/release-manager.md | リリース指示 |
| reviewer | レビュー担当 | skills/assembling-dev-team/references/reviewer.md | レビュー指示 |
| plan-updater | プラン更新担当 | skills/assembling-dev-team/references/plan-updater.md | プラン更新指示 |

### 1.3 プランファイルの分析

プランファイルを読み取り、実装ステップを分解する。
各ステップを TaskCreate でタスクリストに追加する。

## フェーズ2: プラン実装（全ステップ完了まで）

- **入力**: タスクリスト（フェーズ1で作成済み）
- **処理**: 各ステップについて実装→レビュー+リリース（コミット・PR更新・CI）のサイクルを回す
- **出力**: ユーザーへの「フェーズ2完了。レビューをお願いします」報告（PR URL含む）

### 2.1 ステップごとの実装サイクル

各ステップについて以下のサイクルを実行:

#### 2.1.1 実装
- implementer にステップNの実装を依頼（SendMessage type: message）
- TaskUpdate でタスクを in_progress に更新
- implementer からの完了報告を待つ

実装依頼フォーマット:
```
implementer へ:

ステップ{N}の実装をお願いします。

プランファイル: <plan-fileタグのパス>
ステップ番号: {N}

プランファイルを読み取り、該当ステップの内容を実装してください。
完了したら報告してください。
```

#### 2.1.2 レビューとリリース（並列実行）
- reviewer にステップNの実装レビューを依頼（SendMessage type: message）
- release-manager にステップNのリリースを依頼（SendMessage type: message）
- 両方からの報告を待つ

レビュー依頼フォーマット:
```
reviewer へ:

ステップ{N}の実装レビューをお願いします。

レビューフェーズ: フェーズ2（実装中）
プランファイル: <plan-fileタグのパス>
ステップ番号: {N}

**対象ファイル一覧**:
{implementerの完了報告から変更ファイル一覧を転記}

当該ステップの範囲のみを対象にレビューしてください。
指摘があれば具体的に報告してください。
```

リリース依頼フォーマット:
```
release-manager へ:

ステップ{N}の実装をリリースしてください（コミット→PR更新→CIの自律実行）。

プランファイル: <plan-fileタグのパス>
ステップ番号: {N}

**implementerの報告内容**:
変更ファイル一覧:
{implementerの完了報告から変更ファイル一覧を転記}

概要:
{implementerの完了報告から概要を転記}

以下の手順で自律的に進めてください：
1) semantic-committingでコミット作成
2) updating-pr-title-and-descriptionでPR更新
3) monitor-ciでCIチェック
すべて完了したら結果を報告してください。
```

#### 2.1.3 指摘への対応
- reviewer から指摘がある場合: reviewer が implementer に直接指摘を送付し、リーダーにも共有する。リーダーは指摘内容を確認し、修正完了を追跡する → 修正完了後に再レビュー
- 指摘がない場合: TaskUpdate でタスクを completed に更新

#### 2.1.4 次ステップへ
- 次のステップがあれば 2.1.1 に戻る
- 全ステップ完了なら 2.2 へ

### 2.2 全ステップ完了後の最終確認

release-managerからの最終報告（PR URL、CI結果）を確認し、ユーザーに結果を報告する。

- release-managerからの最終報告（PR URL、CI結果）を確認
- ユーザーに「フェーズ2完了。レビューをお願いします」と報告（PR URLを含む）

## フェーズ3: 外部レビュー対応（指摘がなくなるまで）

- **入力**: ユーザーやCodex等のチームメンバー以外からのレビュー指摘
- **処理**: 指摘を振り分け（計画変更 → plan-updaterがプラン更新 / 実装修正 → 3-Aレビュー（3.1.1）→ 修正サイクル（3.2） / CI影響 → release-manager対応）
- **出力**: 指摘対応完了報告

### 3.1 指摘の受け取りと振り分け

外部レビュー（ユーザー、Codex等チームメンバー以外からの指摘）の受け口は**常にリーダーに集約**する。他メンバーに直接届いた場合は、そのメンバーは自己判断で対応せず、リーダーにメッセージで転送すること。

リーダーが指摘を受け取ったら、以下の振り分けルールに従って対応先を判定する:

| 指摘の種類 | 対応先 | アクション |
|-----------|--------|-----------|
| 計画変更が必要 | plan-updater | プランファイル更新を依頼 → 完了後にbroadcastで全メンバーに再読み込みを通知 → 必要に応じてタスクリスト更新（TaskCreate / TaskUpdate） |
| 実装の修正が必要 | reviewer → implementer | まずフェーズ3-Aレビュー（3.1.1）→ 修正サイクル（3.2）を実行 |
| CI/品質/リリースへの影響 | release-manager | release-managerに対応依頼（必要に応じて他メンバーにも同報） |

複数カテゴリにまたがる場合は、リーダーが優先順位をつけて順次対応する。

#### 3.1.1 フェーズ3-Aレビュー（実装修正の前段）

「実装の修正が必要」と判断した場合、修正サイクル（3.2）に入る前に reviewer にフェーズ3-Aレビューを依頼する。reviewer の評価報告（妥当性・影響範囲・検証観点）を受けてから、implementer に修正を依頼する。

フェーズ3-Aレビュー依頼フォーマット:
```
reviewer へ:

外部指摘の事前評価をお願いします。

レビューフェーズ: フェーズ3-A（外部指摘受理直後/実装前）
プランファイル: <plan-fileタグのパス>

**外部指摘内容**:
{外部指摘の要約}

**関連ファイル一覧**:
{指摘に関連するファイルパス}

指摘の妥当性評価、影響範囲の特定、修正後の検証観点を報告してください。
```

### 3.2 修正サイクル

フェーズ3-Aレビューの評価を踏まえ、フェーズ2と同様のサイクルで修正を実施:

1. reviewer の3-A評価に基づき、implementer に修正を依頼（リーダーからSendMessage）→ implementer の修正完了報告を待つ
2. reviewer に**フェーズ3-B（修正完了後）**のレビューを依頼 + release-manager にリリース依頼（コミット→PR更新→CI。後続対応はrelease-managerに一任）（並列実行）

フェーズ3-Bレビュー依頼フォーマット:
```
reviewer へ:

修正完了後のレビューをお願いします。

レビューフェーズ: フェーズ3-B（修正完了後）
プランファイル: <plan-fileタグのパス>

**対象ファイル一覧**:
{implementerの完了報告から変更ファイル一覧を転記}

**元の外部指摘内容**:
{対応した外部指摘の要約}

外部指摘の解消確認に加え、全体再レビューを実施してください。
指摘があれば具体的に報告してください。
```

### 3.3 収束判定

ユーザーからの指摘がなくなるまで 3.1〜3.2 を繰り返す。

## チーム解散（ユーザーの明示的な指示があった場合のみ）

<important>

全タスク完了後もチームは維持し、ユーザーの明示的な指示があるまで解散しないこと。

</important>

ユーザーから「解散」等の指示があった場合のみ:

1. 各メンバーに感想を求める（SendMessage type: message）
   - 今回の作業で感じたこと、改善点等
2. 全メンバーの感想が出揃うまで待つ
3. 各メンバーにシャットダウンリクエストを送信（SendMessage type: shutdown_request）
4. 全メンバーのシャットダウン確認を待つ
5. TeamDelete でチームリソースを削除
6. ユーザーに完了報告

</procedure>
