---
name: codex-plan-review
description: planファイルのレビューを依頼された際に使用。Codex CLIを使ってplanファイル自体の実現可能性・技術的妥当性・抜け漏れをレビューし、指摘をタスクリスト化して収束するまで繰り返します。
allowed-tools: Bash, Write, Read, Edit, TaskCreate, TaskUpdate
model: sonnet
context: fork
---

# Codex CLIを使ったplanファイルレビュー

planファイルの実現可能性、技術的妥当性、抜け漏れやリスクについて、Codex CLIを使って客観的にレビューします。

## 実行手順

<procedure>

### 1. 開発日誌の取得（コンテキストにある場合）

会話のコンテキスト内にesa URLの開発日誌が言及されている場合、以下の手順で取得してください：

#### 1.1 post番号の抽出

esa URLからpost番号を抽出（例：`https://yasuhisa.esa.io/posts/1234` → `1234`）

#### 1.2 YAMLの直接取得

`esa-llm-scoped-guard fetch` コマンドでYAMLを直接取得：

```bash
esa-llm-scoped-guard fetch -post <post_number> | tee .claude_work/dev_diary.yaml
```

**成功の場合**: YAMLが `.claude_work/dev_diary.yaml` に保存されるので、次のステップへ進む

**失敗の場合**: エラーメッセージをユーザーに報告し、このステップをスキップ

開発日誌がコンテキストにない場合は、このステップ全体をスキップしてください。

### 2. planファイルの特定と最新化

#### 2.1 planファイルの取得

`.claude_work/plans/`配下からplanファイルを取得してください：

```bash
ls .claude_work/plans/*.md
```

git worktree運用のため、単一のplanファイルが存在する前提です。

このファイルパスを以下のように定義します：

<plan-file>

```
<取得したplanファイルのパス>
```

</plan-file>

#### 2.2 planファイルの最新化チェック

**重要**: Codexはplanファイルに基づいてレビューするため、planファイルが最新でないと意味がない

1. planファイルを読み取る

2. 会話コンテキスト（開発日誌が取得されている場合はその内容も含む）と比較し、以下の観点で確認：
   - **前提条件**: ユーザーとの会話や開発日誌で決まった技術選択・制約がplanに含まれているか
   - **仕様変更**: 当初の要件から変更された点がplanに反映されているか
   - **新規決定事項**: 会話中や開発日誌に記載された実装方針・アプローチがplanに含まれているか
   - **削除された要件**: もはや不要になった要件がplanから削除されているか

3. **差分がある場合**:
   - 差分内容（追加・修正・削除すべき箇所）を具体的にユーザーに提示
   - 修正可否を確認し、ユーザー承認後にplanファイルを修正（Editツール使用）

4. **差分がない場合**: 次のステップへ進む

#### 2.3 ユーザー発言ログとの整合性確認

`.claude_work/user_prompts.txt` が存在する場合、planファイルのユーザー発言ログセクションに書き漏れがないか確認する：

1. `.claude_work/user_prompts.txt` を読み取る
2. planファイルの「ユーザー発言」セクション（生ログ・要約）と突き合わせる
3. 以下の観点で確認：
   - ユーザーが明示的に要件・制約として述べた内容がplanに反映されているか
   - ユーザーの意図や方針決定が漏れていないか
4. **書き漏れがある場合**: 漏れている内容を具体的にユーザーに提示し、planへの反映要否を確認

### 3. Codex CLIでのレビュー実行

Bash経由で`codex review -`を使ってレビューを実行してください。

**重要**: `codex review -`はリポジトリルートで実行すること（相対パスが前提）

<example>

**開発日誌がない場合のコマンド例：**

```bash
echo "以下のplanファイルを日本語でレビューしてください。

## レビュー対象
- planファイル: <plan-fileタグで定義されたパス>
- ユーザー発言ログ: .claude_work/user_prompts.txt（存在する場合）

## レビュー方針
- **時間をかけてコードベースを徹底的に読むこと**
- planファイルで言及されているファイルや関連ファイルはすべて確認すること
- 網羅的にレビューし、指摘漏れがないようにすること
- 各観点について具体的なコード箇所を参照しながらレビューすること
- **レビュー結果が網羅的で一度に多くなっても構わない**（指摘は詳細かつ具体的に）

## レビューの観点

### 1. 実現可能性・技術的妥当性
- planで述べられている実装方針は技術的に実現可能か
- 使用予定のライブラリ、API、アーキテクチャは適切か
- 既存のコードベース構造と整合性があるか

### 2. 要件との整合性
- planが解決しようとしている課題は明確か
- 提案されている解決策は要件を満たしているか
- 過不足なく要件をカバーしているか

### 3. 抜け漏れ・リスクの指摘
- 考慮されていないエッジケースはないか
- 潜在的なリスク（パフォーマンス、セキュリティ、保守性）はないか
- 依存関係や影響範囲で見落としはないか

### 4. 実装順序・優先度
- 提案されている実装順序は妥当か
- 依存関係を考慮した適切な順序になっているか

### 5. ユーザー意図との整合性
- .claude_work/user_prompts.txt に記録されたユーザーの発言・指示がplanに適切に反映されているか
- ユーザーが明示的に述べた要件や制約が漏れていないか

出力は日本語で、具体的な指摘と改善提案を含めてください。" | codex review -
```

**開発日誌がある場合のコマンド例：**

```bash
echo "以下のplanファイルを日本語でレビューしてください。

## レビュー対象
- planファイル: <plan-fileタグで定義されたパス>
- 開発日誌: .claude_work/dev_diary.yaml
- ユーザー発言ログ: .claude_work/user_prompts.txt（存在する場合）

## レビュー方針
- **時間をかけてコードベースを徹底的に読むこと**
- planファイルで言及されているファイルや関連ファイルはすべて確認すること
- 網羅的にレビューし、指摘漏れがないようにすること
- 各観点について具体的なコード箇所を参照しながらレビューすること
- **レビュー結果が網羅的で一度に多くなっても構わない**（指摘は詳細かつ具体的に）

## レビューの観点

### 1. 実現可能性・技術的妥当性
- planで述べられている実装方針は技術的に実現可能か
- 使用予定のライブラリ、API、アーキテクチャは適切か
- 既存のコードベース構造と整合性があるか

### 2. 要件との整合性
- planが解決しようとしている課題は明確か
- 提案されている解決策は要件を満たしているか
- 過不足なく要件をカバーしているか

### 3. 抜け漏れ・リスクの指摘
- 考慮されていないエッジケースはないか
- 潜在的なリスク（パフォーマンス、セキュリティ、保守性）はないか
- 依存関係や影響範囲で見落としはないか

### 4. 実装順序・優先度
- 提案されている実装順序は妥当か
- 依存関係を考慮した適切な順序になっているか

### 5. 開発日誌との整合性
- 開発日誌に記載された開発方針・過去の決定事項と矛盾していないか
- 開発日誌で言及されている懸念事項がplanで対処されているか

### 6. ユーザー意図との整合性
- .claude_work/user_prompts.txt に記録されたユーザーの発言・指示がplanに適切に反映されているか
- ユーザーが明示的に述べた要件や制約が漏れていないか

出力は日本語で、具体的な指摘と改善提案を含めてください。" | codex review -
```

</example>

<important>

- ファイルの内容ではなく、ファイルパスを渡すことで、Codexが直接ファイルを読み取ります
- **毎回新規セッションでレビューすること**（`resume`は使用禁止）
- **Codexは**過去のレビュー結果や前回の指摘には一切言及しないこと
- **Codexは**プロンプトに記載された観点のみでレビューすること（「前回の指摘は直りましたか？」などの余計な質問をしない）

</important>

### 4. レビュー結果の処理

#### 4.1 レビュー結果の確認

Codexの出力（Bashツールの実行結果）から、指摘内容を把握する。

#### 4.2 指摘の分類とタスクリスト化

指摘を以下のように分類し、**必ずClaude CodeのTaskCreate/TaskUpdateツールを使ってタスクリストに追加する**：

| 分類 | 対応 |
|------|------|
| 計画上の指摘・改善提案 | TaskCreateでタスクリストに追加 |
| 仕様に関する質問 | TaskCreateでタスクリストの最後に追加（ユーザーに確認） |

<important>

- すべての指摘はClaude CodeのTaskCreateツールでタスクリストに入れること（忘れ防止）
- **同じ指摘が既にタスクリストにある場合は、新規作成せずTaskUpdateで更新する**（重複防止）
- 仕様に関する質問は、他のタスクを処理した後でユーザーに確認する
- タスクの更新にはTaskUpdateツールを使用

</important>

#### 4.3 タスクの実行

1. タスクリストの順番に従って対応
2. 仕様に関する質問はタスクの最後でユーザーに確認

#### 4.4 収束確認とループ

**指摘が収束していない場合**（新たな修正を行った場合）：
- **最大レビュー回数（5回）に達していない場合のみ**「Codexレビューを再実行する」タスクをリストに追加
- 手順3に戻ってCodexレビューを再実行

**収束条件**:
- Codexからの指摘がなくなった
- または、残りの指摘がすべて「対応不要」と判断された
- または、最大レビュー回数（5回）に達した

<important>

- 指摘が収束するまで基本的にループを続けること（最大5回まで）
- **レビュー回数の管理**: タスク名に回数を含める（例：「Codexレビューを再実行する（2回目）」）
- 最大レビュー回数に達した場合は、それ以上レビュー再実行タスクを追加せず停止する
- 同一の指摘が繰り返される場合は停止し、「以下の指摘が繰り返されたため停止しました」とユーザーに報告（繰り返された指摘内容を明記）
- 収束確認のためのレビュー再実行もタスクリストに入れること

</important>

</procedure>
