---
name: codex-review
description: コードレビューを依頼された際に使用。Codex CLIを使ってplanファイルと開発日誌（コンテキストにある場合）を参照し、実装が計画に沿っているかをレビューし、指摘をタスクリスト化して収束するまで繰り返します。
allowed-tools: Bash, Write, Edit, Read, TaskCreate, TaskUpdate
model: sonnet
context: fork
---

# Codex CLIを使ったコードレビュー

コードの変更内容に対してcodex CLIを使って客観的なレビューを実施します。

## 実行手順

<procedure>

### 1. デフォルトブランチの取得

まず、リポジトリのデフォルトブランチを取得してください：

```bash
git symbolic-ref refs/remotes/origin/HEAD --short | cut -d/ -f2
```

このコマンドでデフォルトブランチ名（main や master など）を取得し、後続のステップで使用します。

### 2. planファイルの特定

`.claude_work/plans/`配下からplanファイルを取得してください：

```bash
ls .claude_work/plans/*.md
```

git worktree運用のため、単一のplanファイルが存在する前提です。

このファイルパスを以下のように定義します：

<plan-file>

```
<取得したplanファイルのパス>
```

</plan-file>

### 3. 開発日誌の取得（コンテキストにある場合）

会話のコンテキスト内にesa URLの開発日誌が言及されている場合、以下の手順で取得してください：

#### 3.1 post番号の抽出

esa URLからpost番号を抽出（例：`https://yasuhisa.esa.io/posts/1234` → `1234`）

#### 3.2 YAMLの直接取得

`esa-llm-scoped-guard fetch` コマンドでYAMLを直接取得：

```bash
esa-llm-scoped-guard fetch -post <post_number> | tee .claude_work/dev_diary.yaml
```

**成功の場合**: YAMLが `.claude_work/dev_diary.yaml` に保存されるので、次のステップへ進む

**失敗の場合**: エラーメッセージをユーザーに報告し、このステップをスキップ

開発日誌がコンテキストにない場合は、このステップ全体をスキップしてください。

### 4. planファイルとの整合性確認

Codexレビュー前に、planファイルを読んで現在の実装（diff）との整合性を確認してください：

1. <plan-file>タグで定義されたパスのファイルを読む（Readツール使用）
2. デフォルトブランチとの差分を確認（`git diff <デフォルトブランチ名>...HEAD`）
3. planの内容と実装にずれがないか確認
4. ずれがある場合はユーザーに報告

### 5. Codex CLIでのレビュー実行

Bash経由で`codex review -`を使ってレビューを実行してください。

**重要**: `codex review -`はリポジトリルートで実行すること（相対パスが前提）

<example>

**開発日誌がない場合のコマンド例：**

```bash
echo "<デフォルトブランチ名>ブランチとの差分を日本語でレビューしてください。

以下のファイルを参照して、計画に沿った実装になっているか確認してください：
- planファイル: <plan-fileタグで定義されたパス>
- ユーザー発言ログ: .claude_work/user_prompts.txt（存在する場合）

## レビュー方針
- **時間をかけてコードベースを徹底的に読むこと**
- 差分で変更されたファイルや関連ファイルはすべて確認すること
- 網羅的にレビューし、指摘漏れがないようにすること
- 各観点について具体的なコード箇所を参照しながらレビューすること
- **レビュー結果が網羅的で一度に多くなっても構わない**（指摘は詳細かつ具体的に）

レビューの観点：
- planに記載された変更内容との整合性
- コードの品質（可読性、保守性）
- 潜在的な問題やバグ
- ユーザー意図との整合性: .claude_work/user_prompts.txt に記録されたユーザーの発言・指示と実装が整合しているか" | codex review -
```

**開発日誌がある場合のコマンド例：**

```bash
echo "<デフォルトブランチ名>ブランチとの差分を日本語でレビューしてください。

以下のファイルを参照して、計画に沿った実装になっているか確認してください：
- planファイル: <plan-fileタグで定義されたパス>
- 開発日誌: .claude_work/dev_diary.yaml
- ユーザー発言ログ: .claude_work/user_prompts.txt（存在する場合）

## レビュー方針
- **時間をかけてコードベースを徹底的に読むこと**
- 差分で変更されたファイルや関連ファイルはすべて確認すること
- 網羅的にレビューし、指摘漏れがないようにすること
- 各観点について具体的なコード箇所を参照しながらレビューすること
- **レビュー結果が網羅的で一度に多くなっても構わない**（指摘は詳細かつ具体的に）

レビューの観点：
- planに記載された変更内容との整合性
- コードの品質（可読性、保守性）
- 潜在的な問題やバグ
- 開発日誌に記載された開発指針との整合性
- ユーザー意図との整合性: .claude_work/user_prompts.txt に記録されたユーザーの発言・指示と実装が整合しているか" | codex review -
```

</example>

<important>

- ファイルの内容ではなく、ファイルパスを渡すことで、Codexが直接ファイルを読み取ります
- **毎回新規セッションでレビューすること**（`resume`は使用禁止）
- **Codexは**過去のレビュー結果や前回の指摘には一切言及しないこと
- **Codexは**プロンプトに記載された観点のみでレビューすること（「前回の指摘は直りましたか？」などの余計な質問をしない）

</important>

### 6. レビュー結果の処理

#### 6.1 レビュー結果の確認

Codexの出力（Bashツールの実行結果）から、指摘内容を把握する。

#### 6.2 指摘の分類とタスクリスト化

指摘を以下のように分類し、**必ずClaude CodeのTaskCreate/TaskUpdateツールを使ってタスクリストに追加する**：

| 分類 | 対応 |
|------|------|
| 実装上の指摘・改善提案 | TaskCreateでタスクリストに追加 |
| 仕様に関する質問 | TaskCreateでタスクリストの最後に追加（ユーザーに確認） |

<important>

- すべての指摘はClaude CodeのTaskCreateツールでタスクリストに入れること（忘れ防止）
- **同じ指摘が既にタスクリストにある場合は、新規作成せずTaskUpdateで更新する**（重複防止）
- 仕様に関する質問は、他のタスクを処理した後でユーザーに確認する
- タスクの更新にはTaskUpdateツールを使用

</important>

#### 6.3 タスクの実行

1. タスクリストの順番に従って対応
2. 仕様に関する質問はタスクの最後でユーザーに確認

#### 6.4 収束確認とループ

**指摘が収束していない場合**（新たな修正を行った場合）：
- **最大レビュー回数（10回）に達していない場合のみ**「Codexレビューを再実行する」タスクをリストに追加
- 手順5に戻ってCodexレビューを再実行

**収束条件**:
- Codexからの指摘がなくなった
- または、残りの指摘がすべて「対応不要」と判断された
- または、最大レビュー回数（10回）に達した

<important>

- 指摘が収束するまで基本的にループを続けること（最大10回まで）
- **レビュー回数の管理**: タスク名に回数を含める（例：「Codexレビューを再実行する（2回目）」）
- 最大レビュー回数に達した場合は、それ以上レビュー再実行タスクを追加せず停止する
- 同一の指摘が繰り返される場合は停止し、「以下の指摘が繰り返されたため停止しました」とユーザーに報告（繰り返された指摘内容を明記）
- 収束確認のためのレビュー再実行もタスクリストに入れること

</important>

</procedure>
