---
name: planning-guardrails
description: Plan modeや計画作成・プラン作成の依頼時に必ず発動し、必須セクションを漏れなく含む計画を作るためのガードレールを提供します。参考情報（URL/過去PR/ファイルパス）とユーザー発言（要約＋生ログ）を必須化し、テストがある場合はTDD前提と正常系/異常系テストケース記載を強制します。
---

# Planning Guardrails

## 目的

Plan modeでの計画作成において、情報の抜けや意図のねじ曲げを防ぎ、レビューで検証しやすいプランを作ること。

## 使用タイミング

Plan modeで計画を作る時は**必ず**このスキルを使用する。

## 必須チェックリスト

- ユーザーは音声入力を使うことがあり、言い間違いやフィラー、感情的な発言が含まれる前提で記録する
- 参考情報（ユーザー提供URL/過去PR/ファイルパス＋短い注釈）
- ユーザー発言（要約）
- ユーザー発言（生ログ、意味は変えず最小整形のみ）
- 背景
- 目的・成功条件
- スコープ（in/out）
- 実装方針（主要アプローチ）
- 実行計画（テストがある場合はTDD前提を明記）
- 公開API/インターフェース変更
- 観測可能な成果/確認手順（実行方法・期待結果）
- 代替案/選択肢（複数案がある場合は比較と採用理由を明記）
- テスト/検証（正常系/異常系のテストケースを必ず記載）
- リスク・前提

## 生ログの整形ルール

- 意図のねじ曲げを防ぎ、レビュー時に発言とプランの整合性を検証できるようにするため、生ログはそのまま保持する
- 言い換え・要約・意味変更は禁止
- 句読点の追加と改行のみ許可

## 不明点の解消

- 必須セクションが埋まらない、または不明点がある場合は `AskUserQuestion` を使って確認し、決定事項を反映してからプランを完成させる
- 質問設計の詳細は `skills/ask-user-choice/SKILL.md` に従う

## テンプレートと例

- 詳細テンプレートと詳細例: `references/plan-template.md`
- 最小例: `references/plan-examples-min.md`
- 詳細例: `references/plan-examples-detailed.md`
