# Detailed Examples

## Example 1: Validation追加（API変更なし）

### 参考情報

- PR-1234: https://github.com/org/repo/pull/1234
  - 注釈: 同様の機能追加でテスト構成が参考になる
- `app/validators/user_input.ts`
  - 注釈: 既存バリデーションの実装位置

### ユーザー発言（要約）

- 既存の処理を壊さずに新しいバリデーションを追加したい
- 追加対象はフォームの「備考」欄

### ユーザー発言（生ログ）

- 「あの えー 既存のやつ こわさずに えっと 追加したいんだけど」
- 「備考 らん の 文字数 えっと 500 まで に したい」

### 背景

- 既存の備考欄で入力が無制限になっており、運用上の制約が必要になった

### 目的・成功条件

- 目的: 備考欄に文字数制限を追加する計画を明確化する
- 成功条件: 参照情報・発言記録・必須セクションが埋まり、テストケースが定義されている

### スコープ

- in: 文字数バリデーション追加の計画
- out: 実装作業、運用設計

### 実装方針

- 既存バリデーション構造を踏襲
- 追加は`app/validators/user_input.ts`に限定
- 文字数判定は既存ユーティリティを再利用

### 実行計画

- テストがあるためTDDで進める
  - 1. 正常系（500文字以内）/異常系（501文字以上）のテストを先に追加
  - 2. 既存バリデーション関数に条件を追加
  - 3. リファクタリングとテスト整理

### 公開API/インターフェース変更

- 変更点の有無: なし

### 観測可能な成果/確認手順

- 実行方法: テスト実行コマンドを実行する
- 期待結果: 500文字以内は成功、501文字以上はエラー
- 失敗時の見え方: テストが失敗し、エラーメッセージに文字数超過が表示される

### テスト/検証

- 正常系: 0〜500文字でバリデーションが通る
- 異常系: 501文字以上でエラーが返る
- 異常系: 空文字が許容されるかどうかの仕様確認テスト

### リスク・前提

- リスク: 既存フォームのバリデーション仕様と衝突する可能性
- 前提: 文字数制限はUI側の表示にも反映される

## Example 2: ログ追加（テストあり）

### 参考情報

- docs/arch.md
  - 注釈: 既存アーキテクチャ制約の確認が必要
- `app/services/order_service.ts`
  - 注釈: ログ追加対象のサービス

### ユーザー発言（要約）

- 重要イベント時のログを増やしたい
- エラー時にコンテキスト情報も出したい

### ユーザー発言（生ログ）

- 「ログ えっと もっと出したい できれば 重要なとこ」
- 「エラー の とき 何が起きたか もうちょい ほしい」

### 背景

- 障害調査時に情報不足が多く、原因特定に時間がかかっている

### 目的・成功条件

- 目的: 重要イベント/エラー時のログ追加計画を明確化する
- 成功条件: 参照情報とテストケースが明記されている

### スコープ

- in: `order_service`でのログ追加計画
- out: 監視基盤の変更

### 実装方針

- 重要イベントのみログ追加し、既存ログ基盤を利用
- エラー時は注文ID/ユーザーIDをログに含める

### 実行計画

- テストがあるためTDDで進める
  - 1. 正常系/異常系のログ出力テストを先に作成
  - 2. ログ出力実装
  - 3. テスト更新とリファクタリング

### 公開API/インターフェース変更

- 変更点の有無: なし

### 観測可能な成果/確認手順

- 実行方法: ログ出力テストを実行する
- 期待結果: 重要イベント/例外時にログが出る
- 失敗時の見え方: テスト失敗、ログ未出力が示される

### テスト/検証

- 正常系: 重要イベント発生時にログが出る
- 異常系: 例外時に注文ID/ユーザーIDを含むログが出る
- 異常系: ログ出力失敗時のフォールバック動作

### リスク・前提

- リスク: ログ増加によるコスト増
- 前提: 既存ログフォーマットが維持される

## Example 3: API変更あり（スキーマ更新）

### 参考情報

- PR-1200: https://github.com/org/repo/pull/1200
  - 注釈: スキーマ変更の影響分析の参考
- `app/api/v1/user_controller.ts`
  - 注釈: レスポンス生成ロジックの実装位置
- `app/contracts/user.json`
  - 注釈: スキーマ定義の参照元

### ユーザー発言（要約）

- APIレスポンスに`nickname`を追加したい
- 後方互換性は維持したい

### ユーザー発言（生ログ）

- 「レスポンス に えっと ニックネーム 追加 したい」
- 「あと 互換性 こわさない で」

### 背景

- クライアント側でユーザー名の表記揺れが起きており、別名表示を求められている

### 目的・成功条件

- 目的: APIレスポンス拡張の計画を明確化する
- 成功条件: 互換性/テストケース/影響範囲が明記されている

### スコープ

- in: APIスキーマとレスポンス拡張の計画
- out: クライアントのリリース計画

### 実装方針

- `user.json`スキーマに`nickname`を追加（optional）
- `user_controller.ts`でレスポンスに追加

### 実行計画

- テストがあるためTDDで進める
  - 1. スキーマバリデーションテストを追加
  - 2. コントローラのレスポンステストを追加
  - 3. 実装
  - 4. リファクタリング

### 公開API/インターフェース変更

- 変更点の有無: あり
- 影響範囲: クライアントが新フィールドに未対応でも動作する必要がある

### 観測可能な成果/確認手順

- 実行方法: APIのレスポンステストを実行する
- 期待結果: `nickname`が含まれる/含まれない両方のレスポンスが通る
- 失敗時の見え方: テスト失敗、スキーマバリデーションエラーが出る

### テスト/検証

- 正常系: `nickname`が含まれるレスポンス
- 正常系: `nickname`が未設定でも従来レスポンスが維持される
- 異常系: `nickname`が不正フォーマットの場合にバリデーションエラー

### リスク・前提

- リスク: クライアントのパースが想定外の挙動をする可能性
- 前提: スキーマは後方互換のoptional追加で問題ない
