# Plan Template (Planning Guardrails)

## 参考情報

- [参照名] URL/PR/ファイルパス
- 短い注釈（なぜ重要か、何を参照すべきか）
- 各項目に「何を読むべきか」を1行で添える

## ユーザー発言（要約）

- ユーザーが何を望んでいるかを短く記述
- 「何を」「どの範囲で」「どの制約で」を含める

## ユーザー発言（生ログ）

- 言い換え禁止。句読点の追加と改行のみ許可。
- フィラーや言い間違い、感情的発言もそのまま残す。

## 背景

- なぜこの要望が出たか、制約や経緯を2〜4行で記述
- いつ/どの文脈で問題化したかを入れる

## 目的・成功条件

- 目的: 1文で「何を解決するか」を書く
- 成功条件: 観測可能な判定条件（例: テスト/コマンド/具体的出力）

## スコープ

- in: 対象機能/範囲を具体名で列挙
- out: やらない範囲を明示

## 実装方針

- 主要アプローチ（1〜3個）
- 触る主要ファイル/モジュール
- 重要な制約（互換性/性能/安全性）

## 実行計画

- テストがある場合はTDD前提で進めることを明記
- 3〜8ステップで手順を箇条書き
- 依存があれば順序理由も一行で補足

## 公開API/インターフェース変更

- 変更点の有無
- 変更がある場合: 影響範囲・互換性方針・必要な移行

## 代替案/選択肢

- 選択肢A/B/Cを列挙（実現可能なもののみ）
- 各選択肢のメリット/デメリット（観点を揃える）
  - 例: 開発工数・保守性・性能・互換性・リスク
- 採用理由と不採用理由を明記
  - 例: 「Bが最も影響範囲が小さく、既存設計と整合」

## 観測可能な成果/確認手順

- 実行方法（コマンド/操作手順）
- 期待結果（具体的な出力・状態）
- 失敗時の見え方（エラー/ログ/戻り値）

## テスト/検証

- 正常系: 代表ケースを2〜5件
- 異常系: 境界/例外/失敗パターンを2〜5件
- テスト名や対象が分かる粒度で書く

## リスク・前提

- リスク: 具体的な影響と起こりうる条件
- 前提: 依存関係/制約/外部要因
